/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.debug.ui.jres.JREsUpdater;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.datamodel.validate.ValidationManager;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.FacetMatchCache;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class WebServiceRuntimeTests
extends TestCase {
    private final String SERVER_INSTALL_PATH_TC55 = System.getProperty("org.eclipse.jst.server.tomcat.55");
    private final String SERVER_INSTALL_PATH_TC50 = System.getProperty("org.eclipse.jst.server.tomcat.50");
    private final String SERVER_INSTALL_PATH_TC41 = System.getProperty("org.eclipse.jst.server.tomcat.41");
    private final String JAVA15_VM_INSTALL_PATH = System.getProperty("java.15.install.path");
    private final String JAVA15_VM_INSTALL_TYPE = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    private final String JAVA15_VM_INSTALL_NAME = "Java15";
    private final String JAVA15_VM_INSTALL_JAVADOC = "http://java.sun.com/j2se/1.5.0/docs/api/";
    private final String RUNTIMETYPEID_TC55 = "org.eclipse.jst.server.tomcat.runtime.55";
    private final String SERVERTYPEID_TC55 = "org.eclipse.jst.server.tomcat.55";
    private final String RUNTIMETYPEID_TC50 = "org.eclipse.jst.server.tomcat.runtime.50";
    private final String SERVERTYPEID_TC50 = "org.eclipse.jst.server.tomcat.50";
    private final String RUNTIMETYPEID_TC41 = "org.eclipse.jst.server.tomcat.runtime.41";
    private final String SERVERTYPEID_TC41 = "org.eclipse.jst.server.tomcat.41";
    private final String RUNTIMEID_TC55 = "Tomcat55Runtime";
    private final String RUNTIMEID_TC50 = "Tomcat50Runtime";
    private final String RUNTIMEID_TC41 = "Tomcat41Runtime";
    private final String AXIS_RUNTIME = "org.eclipse.jst.ws.axis.creation.axisWebServiceRT";
    private final String SERVICE_IMPL_JAVA = "org.eclipse.jst.ws.wsImpl.java";
    private final String AXIS_SERVICE_RUNTIME = "org.eclipse.jst.ws.axis.creation.java";
    private final String CLIENT_IMPL_JAVA = "org.eclipse.jst.ws.client.type.java";
    private final String AXIS_CLIENT_RUNTIME_WEB = "org.eclipse.jst.ws.axis.consumption.web";
    private final String AXIS_CLIENT_RUNTIME_JAVA = "org.eclipse.jst.ws.axis.consumption.java";
    private final String SERVICE_SIDE = "s";
    private final String CLIENT_SIDE = "c";
    private final String PROJECT_NAME_PREFIX = "tc";
    private final String PROJECT_NAME_SUFFIX = "project";
    private final IProjectFacetVersion WEB23 = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.3");
    private final IProjectFacetVersion WEB24 = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4");
    private final IProjectFacetVersion JAVA14 = ProjectFacetsManager.getProjectFacet((String)"jst.java").getVersion("1.4");
    private final IProjectFacetVersion JAVA50 = ProjectFacetsManager.getProjectFacet((String)"jst.java").getVersion("5.0");
    private final IProjectFacetVersion UTILITY10 = ProjectFacetsManager.getProjectFacet((String)"jst.utility").getVersion("1.0");
    private final IFacetedProjectTemplate TEMPLATE_WEB = ProjectFacetsManager.getTemplate((String)"template.jst.web");
    private final IFacetedProjectTemplate TEMPLATE_UTILITY = ProjectFacetsManager.getTemplate((String)"template.jst.utility");
    private int multiplesForProjectCreation;

    public static Test suite() {
        return new TestSuite(WebServiceRuntimeTests.class);
    }

    private void init() {
        try {
            WebServiceRuntimeTests.assertNotNull((Object)this.SERVER_INSTALL_PATH_TC55);
            WebServiceRuntimeTests.assertNotNull((Object)this.SERVER_INSTALL_PATH_TC50);
            WebServiceRuntimeTests.assertNotNull((Object)this.SERVER_INSTALL_PATH_TC41);
            WebServiceRuntimeTests.assertNotNull((Object)this.JAVA15_VM_INSTALL_PATH);
            this.createTomcatServerRuntime("Tomcat41Runtime", "org.eclipse.jst.server.tomcat.runtime.41", this.SERVER_INSTALL_PATH_TC41);
            this.createTomcatServerRuntime("Tomcat50Runtime", "org.eclipse.jst.server.tomcat.runtime.50", this.SERVER_INSTALL_PATH_TC50);
            this.createTomcatServerRuntime("Tomcat55Runtime", "org.eclipse.jst.server.tomcat.runtime.55", this.SERVER_INSTALL_PATH_TC55);
            String multiples = System.getProperty("multiples");
            this.multiplesForProjectCreation = multiples != null && Integer.parseInt(multiples) > 0 ? Integer.parseInt(multiples) : 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            WebServiceRuntimeTests.fail();
        }
    }

    private IRuntime createTomcatServerRuntime(String runtimeId, String runtimeTypeId, String serverInstallPath) throws Exception {
        IRuntimeType rt = ServerCore.findRuntimeType((String)runtimeTypeId);
        IRuntimeWorkingCopy wc = rt.createRuntime(runtimeId, null);
        wc.setLocation((IPath)new Path(serverInstallPath));
        IRuntime runtime = wc.save(true, null);
        if (runtimeTypeId.equals("org.eclipse.jst.server.tomcat.runtime.55")) {
            IVMInstallType type = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
            VMStandin newVM = new VMStandin(type, this.createUniqueId(type));
            newVM.setInstallLocation(new File(this.JAVA15_VM_INSTALL_PATH).getAbsoluteFile());
            newVM.setName("Java15");
            newVM.setJavadocLocation(new URL("http://java.sun.com/j2se/1.5.0/docs/api/"));
            if (newVM instanceof IVMInstall2) {
                IVMInstall2 newVM2 = (IVMInstall2)newVM;
                newVM2.setVMArgs(null);
            }
            newVM.setLibraryLocations(null);
            IVMInstall[] vms = new IVMInstall[]{newVM};
            JREsUpdater updater = new JREsUpdater();
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            updater.updateJRESettings(vms, defaultVM);
            IVMInstallType vmType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
            IVMInstall java15VM = vmType.findVMInstallByName("Java15");
            IRuntimeWorkingCopy wc2 = runtime.createWorkingCopy();
            ITomcatRuntimeWorkingCopy tcwc = (ITomcatRuntimeWorkingCopy)wc2.loadAdapter(ITomcatRuntimeWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
            tcwc.setVMInstall(java15VM);
            wc2.save(true, null);
        }
        return ServerCore.findRuntime((String)runtimeId);
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    public void testProjectCreationAndFiltering() {
        this.init();
        String[] templateIds = new String[]{"template.jst.web", "template.jst.web", "template.jst.web", "template.jst.web", "template.jst.web", "template.jst.web", "template.jst.utility", "template.jst.utility", "template.jst.utility"};
        String[] scenarios = new String[]{"s", "s", "s", "c", "c", "c", "c", "c", "c"};
        String[] serviceClientRuntimeIds = new String[]{"org.eclipse.jst.ws.axis.creation.java", "org.eclipse.jst.ws.axis.creation.java", "org.eclipse.jst.ws.axis.creation.java", "org.eclipse.jst.ws.axis.consumption.web", "org.eclipse.jst.ws.axis.consumption.web", "org.eclipse.jst.ws.axis.consumption.web", "org.eclipse.jst.ws.axis.consumption.java", "org.eclipse.jst.ws.axis.consumption.java", "org.eclipse.jst.ws.axis.consumption.java"};
        String[] serverTypes = new String[]{"org.eclipse.jst.server.tomcat.41", "org.eclipse.jst.server.tomcat.50", "org.eclipse.jst.server.tomcat.55", "org.eclipse.jst.server.tomcat.41", "org.eclipse.jst.server.tomcat.50", "org.eclipse.jst.server.tomcat.55", "org.eclipse.jst.server.tomcat.41", "org.eclipse.jst.server.tomcat.50", "org.eclipse.jst.server.tomcat.55"};
        IProjectFacetVersion[][] expectedFacets = new IProjectFacetVersion[][]{{this.WEB23, this.JAVA14}, {this.WEB24, this.JAVA14}, {this.WEB24, this.JAVA50}, {this.WEB23, this.JAVA14}, {this.WEB24, this.JAVA14}, {this.WEB24, this.JAVA50}, {this.UTILITY10, this.JAVA14}, {this.UTILITY10, this.JAVA14}, {this.UTILITY10, this.JAVA50}};
        String[] expectedRuntimes = new String[]{"Tomcat41Runtime", "Tomcat50Runtime", "Tomcat55Runtime", "Tomcat41Runtime", "Tomcat50Runtime", "Tomcat55Runtime", "Tomcat41Runtime", "Tomcat50Runtime", "Tomcat55Runtime"};
        String bigPrefix = "tc0project";
        String[] expectedProjectsForAxisService = new String[]{String.valueOf(bigPrefix) + "0", String.valueOf(bigPrefix) + "1", String.valueOf(bigPrefix) + "2", String.valueOf(bigPrefix) + "3", String.valueOf(bigPrefix) + "4", String.valueOf(bigPrefix) + "5"};
        String[] expectedProjectsForAxisClient = new String[]{String.valueOf(bigPrefix) + "0", String.valueOf(bigPrefix) + "1", String.valueOf(bigPrefix) + "2", String.valueOf(bigPrefix) + "3", String.valueOf(bigPrefix) + "4", String.valueOf(bigPrefix) + "5", String.valueOf(bigPrefix) + "6", String.valueOf(bigPrefix) + "7", String.valueOf(bigPrefix) + "8"};
        boolean[] blArray = new boolean[9];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        boolean[] expectedBooleansForAxisService = blArray;
        boolean[] blArray2 = new boolean[9];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        boolean[] expectedBooleansForAxisClientWeb = blArray2;
        boolean[] blArray3 = new boolean[9];
        blArray3[6] = true;
        blArray3[7] = true;
        blArray3[8] = true;
        boolean[] expectedBooleansForAxisClientJava = blArray3;
        ValidationManager manager = new ValidationManager();
        manager.disableAutoBuild();
        int i = 0;
        while (i < this.multiplesForProjectCreation) {
            this.createProjects(templateIds, scenarios, serviceClientRuntimeIds, serverTypes, "tc" + i);
            ++i;
        }
        manager.restoreAutoBuild();
        int j = 0;
        while (j < expectedFacets.length) {
            String projectName = String.valueOf(bigPrefix) + j;
            IProject project = ProjectUtilities.getProject((String)projectName);
            WebServiceRuntimeTests.assertNotNull((Object)project);
            WebServiceRuntimeTests.assertTrue((boolean)project.exists());
            try {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                WebServiceRuntimeTests.assertNotNull((Object)fProject);
                for (IProjectFacetVersion pfv : fProject.getProjectFacets()) {
                    System.out.println("facet=" + pfv.getProjectFacet().getId() + ", version=" + pfv.getVersionString());
                }
                int k = 0;
                while (k < expectedFacets[j].length) {
                    WebServiceRuntimeTests.assertTrue((boolean)fProject.hasProjectFacet(expectedFacets[j][k]));
                    ++k;
                }
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = fProject.getRuntime();
                WebServiceRuntimeTests.assertNotNull((Object)fRuntime);
                IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
                WebServiceRuntimeTests.assertNotNull((Object)sRuntime);
                WebServiceRuntimeTests.assertTrue((boolean)sRuntime.getId().equals(expectedRuntimes[j]));
            }
            catch (CoreException coreException) {
                WebServiceRuntimeTests.fail();
            }
            ++j;
        }
        String serviceType = String.valueOf(String.valueOf(0)) + "/" + "org.eclipse.jst.ws.wsImpl.java";
        String[] projectsForAxisService = WebServiceRuntimeExtensionUtils2.getProjectsForServiceTypeAndRuntime((String)serviceType, (String)"org.eclipse.jst.ws.axis.creation.axisWebServiceRT");
        WebServiceRuntimeTests.assertEquals((int)expectedProjectsForAxisService.length, (int)projectsForAxisService.length);
        ArrayList<String> projectsForAxisServiceList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < projectsForAxisService.length) {
            projectsForAxisServiceList.add(projectsForAxisService[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < expectedProjectsForAxisService.length) {
            WebServiceRuntimeTests.assertTrue((boolean)projectsForAxisServiceList.contains(expectedProjectsForAxisService[i2]));
            ++i2;
        }
        String[] projectsForAxisClient = WebServiceRuntimeExtensionUtils2.getProjectsForClientTypeAndRuntime((String)"org.eclipse.jst.ws.client.type.java", (String)"org.eclipse.jst.ws.axis.creation.axisWebServiceRT");
        WebServiceRuntimeTests.assertEquals((int)expectedProjectsForAxisClient.length, (int)projectsForAxisClient.length);
        ArrayList<String> projectsForAxisClientList = new ArrayList<String>();
        int i3 = 0;
        while (i3 < projectsForAxisClient.length) {
            projectsForAxisClientList.add(projectsForAxisClient[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < expectedProjectsForAxisClient.length) {
            WebServiceRuntimeTests.assertTrue((boolean)projectsForAxisClientList.contains(expectedProjectsForAxisClient[i3]));
            ++i3;
        }
        i3 = 0;
        while (i3 < expectedBooleansForAxisService.length) {
            String projectName = String.valueOf(bigPrefix) + i3;
            WebServiceRuntimeTests.assertEquals((boolean)expectedBooleansForAxisService[i3], (boolean)WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportProject((String)"org.eclipse.jst.ws.axis.creation.java", (String)projectName));
            WebServiceRuntimeTests.assertEquals((boolean)expectedBooleansForAxisClientWeb[i3], (boolean)WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportProject((String)"org.eclipse.jst.ws.axis.consumption.web", (String)projectName));
            WebServiceRuntimeTests.assertEquals((boolean)expectedBooleansForAxisClientJava[i3], (boolean)WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportProject((String)"org.eclipse.jst.ws.axis.consumption.java", (String)projectName));
            ++i3;
        }
        manager.disableAutoBuild();
        i3 = 0;
        while (i3 < this.multiplesForProjectCreation) {
            this.deleteProjects(templateIds.length, "tc" + i3);
            ++i3;
        }
        manager.restoreAutoBuild();
    }

    private void deleteProjects(int n, String namePrefix) {
        int i = 0;
        while (i < n) {
            String name = String.valueOf(namePrefix) + "project" + i;
            IProject project = ProjectUtilities.getProject((String)name);
            try {
                project.delete(true, null);
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private void createProjects(String[] templateIds, String[] scenarios, String[] serviceClientRuntimeIds, String[] serverTypes, String namePrefix) {
        int n = templateIds.length;
        int i = 0;
        while (i < n) {
            String name = String.valueOf(namePrefix) + "project" + i;
            RequiredFacetVersion[] rfvs = null;
            rfvs = scenarios[i].equals("c") ? WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById((String)serviceClientRuntimeIds[i]).getRequiredFacetVersions() : (scenarios[i].equals("s") ? WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)serviceClientRuntimeIds[i]).getRequiredFacetVersions() : new RequiredFacetVersion[]{});
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(name);
            command.setTemplateId(templateIds[i]);
            command.setRequiredFacetVersions(rfvs);
            command.setServerFactoryId(serverTypes[i]);
            IStatus status = command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (status.getSeverity() == 4) {
                WebServiceRuntimeTests.fail();
            }
            IProject project = ProjectUtilities.getProject((String)name);
            FacetUtils.addRequiredFacetsToProject((IProject)project, (RequiredFacetVersion[])rfvs, (IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
    }

    public void testProjectTypeFiltering() {
        IFacetedProjectTemplate[] expectedTemplatesForAxisService = new IFacetedProjectTemplate[]{this.TEMPLATE_WEB};
        IFacetedProjectTemplate[] expectedTemplatesForAxisClientWeb = new IFacetedProjectTemplate[]{this.TEMPLATE_WEB};
        IFacetedProjectTemplate[] expectedTemplatesForAxisClientJava = new IFacetedProjectTemplate[]{this.TEMPLATE_UTILITY};
        Set templatesForAxisService = FacetMatchCache.getInstance().getTemplatesForServiceRuntime("org.eclipse.jst.ws.axis.creation.java");
        WebServiceRuntimeTests.assertEquals((int)expectedTemplatesForAxisService.length, (int)templatesForAxisService.size());
        int i = 0;
        while (i < expectedTemplatesForAxisService.length) {
            WebServiceRuntimeTests.assertTrue((boolean)templatesForAxisService.contains(expectedTemplatesForAxisService[i]));
            ++i;
        }
        Set templatesForAxisClientWeb = FacetMatchCache.getInstance().getTemplatesForClientRuntime("org.eclipse.jst.ws.axis.consumption.web");
        WebServiceRuntimeTests.assertEquals((int)expectedTemplatesForAxisClientWeb.length, (int)templatesForAxisClientWeb.size());
        int i2 = 0;
        while (i2 < expectedTemplatesForAxisClientWeb.length) {
            WebServiceRuntimeTests.assertTrue((boolean)templatesForAxisClientWeb.contains(expectedTemplatesForAxisClientWeb[i2]));
            ++i2;
        }
        Set templatesForAxisClientJava = FacetMatchCache.getInstance().getTemplatesForClientRuntime("org.eclipse.jst.ws.axis.consumption.java");
        WebServiceRuntimeTests.assertEquals((int)expectedTemplatesForAxisClientJava.length, (int)templatesForAxisClientJava.size());
        int i3 = 0;
        while (i3 < expectedTemplatesForAxisClientJava.length) {
            WebServiceRuntimeTests.assertTrue((boolean)templatesForAxisClientJava.contains(expectedTemplatesForAxisClientJava[i3]));
            ++i3;
        }
    }
}

