/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumnTagConverter
extends AbstractTagConverter {
    public ColumnTagConverter(Element host) {
        super(host);
    }

    protected Element doConvertRefresh() {
        Node child;
        Element hostEle = this.getHostElement();
        Element resultEle = this.createElement("td");
        Node parent = hostEle.getParentNode();
        if (parent != null && parent.getLocalName().equals("dataTable")) {
            int offset;
            String columnClassesAttr = ((Element)parent).getAttribute("columnClasses");
            ArrayList<String> columnClasses = new ArrayList<String>();
            if (columnClassesAttr != null) {
                StringTokenizer tokenizer = new StringTokenizer(columnClassesAttr, ", ");
                while (tokenizer.hasMoreTokens()) {
                    columnClasses.add(tokenizer.nextToken());
                }
            }
            if ((offset = EditModelQuery.getInstance().getSameTypeNodeIndex((Node)hostEle)) < columnClasses.size()) {
                resultEle.setAttribute("class", (String)columnClasses.get(offset));
            }
        }
        if (EditModelQuery.getInstance().hasNonTransparentChild((Node)hostEle, new String[]{"facet"})) {
            child = hostEle.getFirstChild();
            int index = 0;
            while (child != null) {
                if (!(child instanceof Element) || !JSFDOMUtil.isFacet((Element)child)) {
                    this.addChild(child, new ConvertPosition((Node)resultEle, index++));
                }
                child = child.getNextSibling();
            }
        } else {
            child = this.createText(" ");
            resultEle.appendChild(child);
        }
        return resultEle;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return false;
    }

    public boolean needBorderDecorator() {
        Element hostEle = this.getHostElement();
        Node parent = hostEle.getParentNode();
        return parent == null || !parent.getLocalName().equals("dataTable");
    }
}

