/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.internal.emfworkbench.edit.ChildCommand;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelRetriever;
import org.eclipse.wst.common.internal.emfworkbench.integration.AbstractEditModelCommand;
import org.eclipse.wst.common.internal.emfworkbench.integration.ComposedEditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelCommand;

public class ParentCommand
extends EditModelCommand {
    private List children;
    private ComposedEditModel editModel;
    private List affectedModels;

    public ParentCommand(Command targetCommand, ComposedEditModel anEditModel) {
        super(targetCommand);
        this.editModel = anEditModel;
        this.children = new ArrayList(1);
    }

    public boolean canExecute() {
        return this.getTarget().canExecute();
    }

    protected void computeAffectedModels() {
        ResourceSet set = null;
        List editModels = this.getEditModel().getChildren();
        Iterator it = this.computeAffectedResourceSets().iterator();
        while (it.hasNext()) {
            set = (ResourceSet)it.next();
            int i = 0;
            while (i < editModels.size()) {
                EditModel model = (EditModel)editModels.get(i);
                if (model.getResourceSet() == set) {
                    this.getAffectedModels().add(new EditModelRetriever(model.getEmfContext(), model.getEditModelID(), model.getParams()));
                }
                ++i;
            }
        }
    }

    protected Set computeAffectedResourceSets() {
        Iterator objects = this.getTarget().getAffectedObjects().iterator();
        HashSet<ResourceSet> resourceSets = new HashSet<ResourceSet>();
        Object o = null;
        EObject ref = null;
        ResourceSet set = null;
        while (objects.hasNext()) {
            o = objects.next();
            if (!(o instanceof EObject) || (ref = (EObject)o).eResource() == null || (set = ref.eResource().getResourceSet()) == null) continue;
            resourceSets.add(set);
        }
        return resourceSets;
    }

    protected ChildCommand createChildCommand(EditModelRetriever retriever) {
        return new ChildCommand(this, this.getTarget(), retriever);
    }

    public void execute() {
        this.getTarget().execute();
        this.computeAffectedModels();
        this.pushChildrenForExecute();
    }

    protected void executeInModel(AbstractEditModelCommand cmd) {
        this.getEditModel().getCommandStack().execute((Command)cmd);
    }

    protected List getAffectedModels() {
        if (this.affectedModels == null) {
            this.affectedModels = new ArrayList(1);
        }
        return this.affectedModels;
    }

    protected List getChildren() {
        return this.children;
    }

    protected ComposedEditModel getEditModel() {
        return this.editModel;
    }

    protected void invertChildren() {
        this.invertChildrenExcept(null);
    }

    protected void invertChildrenExcept(ChildCommand caller) {
        int i = 0;
        while (i < this.children.size()) {
            ChildCommand childCmd = (ChildCommand)((Object)this.children.get(i));
            if (caller == null || childCmd != caller) {
                childCmd.invertAndPush();
            }
            ++i;
        }
    }

    protected void invertFrom(ChildCommand caller) {
        this.invertAndPush();
        this.invertChildrenExcept(caller);
    }

    protected void pushChildrenForExecute() {
        int i = 0;
        while (i < this.getAffectedModels().size()) {
            EditModelRetriever retriever = (EditModelRetriever)this.getAffectedModels().get(i);
            ChildCommand command = this.createChildCommand(retriever);
            this.getChildren().add(command);
            command.executeInModel(command);
            ++i;
        }
    }

    public void redo() {
        this.getTarget().redo();
        this.invertChildren();
    }

    public void redoFrom(ChildCommand child) {
        this.invertFrom(child);
    }

    public void undo() {
        this.getTarget().undo();
        this.invertChildren();
    }

    public void undoFrom(ChildCommand child) {
        this.invertFrom(child);
    }
}

