/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmArtifactEdit;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceUnit
extends AbstractPersistenceJpaContextNode
implements PersistenceUnit {
    protected XmlPersistenceUnit xmlPersistenceUnit;
    protected String name;
    protected PersistenceUnitTransactionType specifiedTransactionType;
    protected PersistenceUnitTransactionType defaultTransactionType;
    protected String description;
    protected String provider;
    protected String jtaDataSource;
    protected String nonJtaDataSource;
    protected final List<MappingFileRef> specifiedMappingFileRefs = new ArrayList<MappingFileRef>();
    protected MappingFileRef impliedMappingFileRef;
    protected final List<ClassRef> specifiedClassRefs = new ArrayList<ClassRef>();
    protected final List<ClassRef> impliedClassRefs = new ArrayList<ClassRef>();
    protected Boolean specifiedExcludeUnlistedClasses;
    protected boolean defaultExcludeUnlistedClasses = false;
    protected final List<Property> properties = new ArrayList<Property>();
    protected final List<Generator> generators = new ArrayList<Generator>();
    protected final List<Query> queries = new ArrayList<Query>();
    protected String defaultSchema;
    protected String defaultCatalog;
    protected AccessType defaultAccess;
    protected boolean defaultCascadePersist;

    public GenericPersistenceUnit(Persistence parent, XmlPersistenceUnit persistenceUnit) {
        super(parent);
        this.initialize(persistenceUnit);
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("generators");
        nonUpdateAspectNames.add("queries");
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.persistenceUnit";
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this;
    }

    @Override
    public Persistence getParent() {
        return (Persistence)super.getParent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.xmlPersistenceUnit.setName(newName);
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.isTransactionTypeDefault() ? this.getDefaultTransactionType() : this.getSpecifiedTransactionType();
    }

    @Override
    public PersistenceUnitTransactionType getSpecifiedTransactionType() {
        return this.specifiedTransactionType;
    }

    @Override
    public void setSpecifiedTransactionType(PersistenceUnitTransactionType newTransactionType) {
        PersistenceUnitTransactionType oldTransactionType = this.specifiedTransactionType;
        this.specifiedTransactionType = newTransactionType;
        this.xmlPersistenceUnit.setTransactionType(PersistenceUnitTransactionType.toXmlResourceModel(newTransactionType));
        this.firePropertyChanged("transactionType", (Object)oldTransactionType, (Object)newTransactionType);
    }

    public boolean isTransactionTypeDefault() {
        return this.specifiedTransactionType == null;
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    protected void setDefaultTransactionType(PersistenceUnitTransactionType newTransactionType) {
        PersistenceUnitTransactionType oldTransactionType = this.defaultTransactionType;
        this.defaultTransactionType = newTransactionType;
        this.firePropertyChanged("defaultTransactionType", (Object)oldTransactionType, (Object)newTransactionType);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        this.xmlPersistenceUnit.setDescription(newDescription);
        this.firePropertyChanged("description", oldDescription, newDescription);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String newProvider) {
        String oldProvider = this.provider;
        this.provider = newProvider;
        this.xmlPersistenceUnit.setProvider(newProvider);
        this.firePropertyChanged("provider", oldProvider, newProvider);
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String newJtaDataSource) {
        String oldJtaDataSource = this.jtaDataSource;
        this.jtaDataSource = newJtaDataSource;
        this.xmlPersistenceUnit.setJtaDataSource(newJtaDataSource);
        this.firePropertyChanged("jtaDataSource", oldJtaDataSource, newJtaDataSource);
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String newNonJtaDataSource) {
        String oldNonJtaDataSource = this.nonJtaDataSource;
        this.nonJtaDataSource = newNonJtaDataSource;
        this.xmlPersistenceUnit.setNonJtaDataSource(newNonJtaDataSource);
        this.firePropertyChanged("nonJtaDataSource", oldNonJtaDataSource, newNonJtaDataSource);
    }

    @Override
    public ListIterator<MappingFileRef> mappingFileRefs() {
        if (this.impliedMappingFileRef == null) {
            return this.specifiedMappingFileRefs();
        }
        return new ReadOnlyCompositeListIterator(this.specifiedMappingFileRefs(), (Object)this.impliedMappingFileRef);
    }

    @Override
    public int mappingFileRefsSize() {
        if (this.impliedMappingFileRef == null) {
            return this.specifiedMappingFileRefsSize();
        }
        return 1 + this.specifiedMappingFileRefsSize();
    }

    @Override
    public ListIterator<MappingFileRef> specifiedMappingFileRefs() {
        return new CloneListIterator(this.specifiedMappingFileRefs);
    }

    @Override
    public int specifiedMappingFileRefsSize() {
        return this.specifiedMappingFileRefs.size();
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef() {
        return this.addSpecifiedMappingFileRef(this.specifiedMappingFileRefs.size());
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(int index) {
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        MappingFileRef mappingFileRef = this.buildMappingFileRef(xmlMappingFileRef);
        this.specifiedMappingFileRefs.add(index, mappingFileRef);
        this.xmlPersistenceUnit.getMappingFiles().add(index, (Object)xmlMappingFileRef);
        this.fireItemAdded("specifiedMappingFileRefs", index, mappingFileRef);
        return mappingFileRef;
    }

    @Override
    public void removeSpecifiedMappingFileRef(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef(this.specifiedMappingFileRefs.indexOf(mappingFileRef));
    }

    @Override
    public void removeSpecifiedMappingFileRef(int index) {
        MappingFileRef mappingFileRefRemoved = this.specifiedMappingFileRefs.remove(index);
        mappingFileRefRemoved.dispose();
        this.xmlPersistenceUnit.getMappingFiles().remove(index);
        this.fireItemRemoved("specifiedMappingFileRefs", index, mappingFileRefRemoved);
    }

    protected void addSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        this.addSpecifiedMappingFileRef_(this.specifiedMappingFileRefs.size(), mappingFileRef);
    }

    protected void addSpecifiedMappingFileRef_(int index, MappingFileRef mappingFileRef) {
        this.addItemToList(index, mappingFileRef, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    protected void removeSpecifiedMappingFileRef_(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef_(this.specifiedMappingFileRefs.indexOf(mappingFileRef));
    }

    protected void removeSpecifiedMappingFileRef_(int index) {
        this.specifiedMappingFileRefs.get(index).dispose();
        this.removeItemFromList(index, this.specifiedMappingFileRefs, "specifiedMappingFileRefs");
    }

    @Override
    public MappingFileRef getImpliedMappingFileRef() {
        return this.impliedMappingFileRef;
    }

    protected MappingFileRef setImpliedMappingFileRef() {
        MappingFileRef mappingFileRef;
        if (this.impliedMappingFileRef != null) {
            throw new IllegalStateException("The implied mapping file ref is already set.");
        }
        this.impliedMappingFileRef = mappingFileRef = this.buildMappingFileRef(null);
        this.firePropertyChanged("impliedMappingFileRef", null, mappingFileRef);
        return mappingFileRef;
    }

    protected void unsetImpliedMappingFileRef() {
        if (this.impliedMappingFileRef == null) {
            throw new IllegalStateException("The implied mapping file ref is already unset.");
        }
        MappingFileRef mappingFileRef = this.impliedMappingFileRef;
        this.impliedMappingFileRef.dispose();
        this.impliedMappingFileRef = null;
        this.firePropertyChanged("impliedMappingFileRef", mappingFileRef, null);
    }

    @Override
    public ListIterator<ClassRef> classRefs() {
        return new ReadOnlyCompositeListIterator(new ListIterator[]{this.specifiedClassRefs(), this.impliedClassRefs()});
    }

    @Override
    public int classRefsSize() {
        return this.specifiedClassRefsSize() + this.impliedClassRefsSize();
    }

    @Override
    public ListIterator<ClassRef> specifiedClassRefs() {
        return new CloneListIterator(this.specifiedClassRefs);
    }

    @Override
    public int specifiedClassRefsSize() {
        return this.specifiedClassRefs.size();
    }

    @Override
    public ClassRef addSpecifiedClassRef() {
        return this.addSpecifiedClassRef(this.specifiedClassRefsSize());
    }

    @Override
    public ClassRef addSpecifiedClassRef(int index) {
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        ClassRef classRef = this.buildClassRef(xmlClassRef);
        this.specifiedClassRefs.add(index, classRef);
        this.xmlPersistenceUnit.getClasses().add(index, (Object)xmlClassRef);
        this.fireItemAdded("specifiedClassRefs", index, classRef);
        return classRef;
    }

    @Override
    public void removeSpecifiedClassRef(ClassRef classRef) {
        this.removeSpecifiedClassRef(this.specifiedClassRefs.indexOf(classRef));
    }

    @Override
    public void removeSpecifiedClassRef(int index) {
        ClassRef classRefRemoved = this.specifiedClassRefs.remove(index);
        classRefRemoved.dispose();
        this.xmlPersistenceUnit.getClasses().remove(index);
        this.fireItemRemoved("specifiedClassRefs", index, classRefRemoved);
    }

    protected void addSpecifiedClassRef_(ClassRef classRef) {
        this.addSpecifiedClassRef_(this.specifiedClassRefs.size(), classRef);
    }

    protected void addSpecifiedClassRef_(int index, ClassRef classRef) {
        this.addItemToList(index, classRef, this.specifiedClassRefs, "specifiedClassRefs");
    }

    protected void removeSpecifiedClassRef_(ClassRef classRef) {
        classRef.dispose();
        this.removeSpecifiedClassRef_(this.specifiedClassRefs.indexOf(classRef));
    }

    protected void removeSpecifiedClassRef_(int index) {
        this.removeItemFromList(index, this.specifiedClassRefs, "specifiedClassRefs");
    }

    @Override
    public ListIterator<ClassRef> impliedClassRefs() {
        return new CloneListIterator(this.impliedClassRefs);
    }

    @Override
    public int impliedClassRefsSize() {
        return this.impliedClassRefs.size();
    }

    protected ClassRef addImpliedClassRef(String className) {
        return this.addImpliedClassRef(this.impliedClassRefs.size(), className);
    }

    protected ClassRef addImpliedClassRef(int index, String className) {
        ClassRef classRef = this.buildClassRef(className);
        this.addItemToList(index, classRef, this.impliedClassRefs, "impliedClassRefs");
        return classRef;
    }

    protected void removeImpliedClassRef(ClassRef classRef) {
        classRef.dispose();
        this.removeImpliedClassRef(this.impliedClassRefs.indexOf(classRef));
    }

    protected void removeImpliedClassRef(int index) {
        this.removeItemFromList(index, this.impliedClassRefs, "impliedClassRefs");
    }

    @Override
    public boolean isExcludeUnlistedClasses() {
        return this.getSpecifiedExcludeUnlistedClasses() == null ? this.getDefaultExcludeUnlistedClasses() : this.getSpecifiedExcludeUnlistedClasses().booleanValue();
    }

    @Override
    public Boolean getSpecifiedExcludeUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses;
    }

    @Override
    public void setSpecifiedExcludeUnlistedClasses(Boolean newExcludeUnlistedClasses) {
        Boolean oldExcludeUnlistedClasses = this.specifiedExcludeUnlistedClasses;
        this.specifiedExcludeUnlistedClasses = newExcludeUnlistedClasses;
        this.xmlPersistenceUnit.setExcludeUnlistedClasses(this.specifiedExcludeUnlistedClasses);
        this.firePropertyChanged("specifiedExcludeUnlistedClasses", oldExcludeUnlistedClasses, newExcludeUnlistedClasses);
    }

    @Override
    public boolean getDefaultExcludeUnlistedClasses() {
        return this.defaultExcludeUnlistedClasses;
    }

    @Override
    public ListIterator<Property> properties() {
        return new CloneListIterator(this.properties);
    }

    @Override
    public int propertiesSize() {
        return this.properties.size();
    }

    @Override
    public Property getProperty(String key) {
        if (key == null) {
            throw new IllegalStateException("Cannot getProperty: key is null.");
        }
        for (Property property : this.properties) {
            if (!key.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public ListIterator<Property> propertiesWithPrefix(String keyPrefix) {
        if (keyPrefix == null) {
            throw new IllegalStateException("Cannot find propertiesWithPrefix: keyPrefix is null.");
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (property.getName() == null || !property.getName().startsWith(keyPrefix)) continue;
            properties.add(property);
        }
        return properties.listIterator();
    }

    @Override
    public Property getProperty(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalStateException("Cannot getProperty: key or value is null.");
        }
        for (Property property : this.properties) {
            if (!key.equals(property.getName()) || !value.equals(property.getValue())) continue;
            return property;
        }
        return null;
    }

    protected Property getProperty(int index) {
        return this.properties.get(index);
    }

    protected XmlProperty getXmlProperty(String name, String value) {
        if (this.xmlPersistenceUnit.getProperties() == null) {
            XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        for (XmlProperty xmlProperty : this.xmlPersistenceUnit.getProperties().getProperties()) {
            if (!name.equals(xmlProperty.getName()) || !value.equals(xmlProperty.getValue())) continue;
            return xmlProperty;
        }
        return null;
    }

    @Override
    public void putProperty(String key, String value, boolean allowDuplicates) {
        if (!allowDuplicates && this.containsProperty(key)) {
            this.putXmlProperty(key, value, this.getProperty(key).getValue());
            return;
        }
        if (value != null) {
            XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
            xmlProperty.setName(key);
            xmlProperty.setValue(value);
            this.addXmlProperty(xmlProperty, this.propertiesSize());
            return;
        }
    }

    @Override
    public void replacePropertyValue(String key, String oldValue, String newValue) {
        this.putXmlProperty(key, newValue, oldValue);
    }

    protected void putXmlProperty(String key, String value, String oldValue) {
        if (value == null) {
            this.removeProperty(key);
            return;
        }
        XmlProperty xmlProperty = this.getXmlProperty(key, oldValue);
        if (xmlProperty == null) {
            throw new NoSuchElementException("Missing Property name: " + key + ", value: " + oldValue);
        }
        xmlProperty.setValue(value);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.getProperty(key) != null;
    }

    @Override
    public Property addProperty() {
        return this.addProperty(this.propertiesSize());
    }

    @Override
    public Property addProperty(int index) {
        return this.addXmlProperty(PersistenceFactory.eINSTANCE.createXmlProperty(), index);
    }

    protected Property addXmlProperty(XmlProperty xmlProperty, int index) {
        Property property = this.buildProperty(xmlProperty);
        if (this.xmlPersistenceUnit.getProperties() == null) {
            XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        this.properties.add(index, property);
        this.xmlPersistenceUnit.getProperties().getProperties().add(index, (Object)xmlProperty);
        this.fireItemAdded("properties", index, property);
        return property;
    }

    @Override
    public void removeProperty(String key) {
        this.removeProperty(this.getProperty(key));
    }

    @Override
    public void removeProperty(String key, String value) {
        this.removeProperty(this.getProperty(key, value));
    }

    @Override
    public void removeProperty(Property property) {
        if (property != null) {
            this.removeProperty(this.properties.indexOf(property));
        }
    }

    protected void removeProperty(int index) {
        Property propertyRemoved = this.properties.remove(index);
        this.xmlPersistenceUnit.getProperties().getProperties().remove(index);
        if (this.xmlPersistenceUnit.getProperties().getProperties().isEmpty()) {
            this.xmlPersistenceUnit.setProperties(null);
        }
        this.fireItemRemoved("properties", index, propertyRemoved);
    }

    protected void addProperty_(Property property) {
        this.addProperty_(this.properties.size(), property);
    }

    protected void addProperty_(int index, Property property) {
        this.addItemToList(index, property, this.properties, "properties");
    }

    protected void removeProperty_(Property property) {
        this.removeProperty_(this.properties.indexOf(property));
    }

    protected void removeProperty_(int index) {
        this.removeItemFromList(index, this.properties, "properties");
    }

    protected PersistenceUnitDefaults persistenceUnitDefaults() {
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            PersistenceUnitDefaults persistenceUnitDefaults = mappingFileRef.getPersistenceUnitDefaults();
            if (persistenceUnitDefaults == null) continue;
            return persistenceUnitDefaults;
        }
        return null;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchema", oldDefaultSchema, newDefaultSchema);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalog", oldDefaultCatalog, newDefaultCatalog);
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType newDefaultAccess) {
        AccessType oldDefaultAccess = this.defaultAccess;
        this.defaultAccess = newDefaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)oldDefaultAccess, (Object)newDefaultAccess);
    }

    @Override
    public boolean getDefaultCascadePersist() {
        return this.defaultCascadePersist;
    }

    protected void setDefaultCascadePersist(boolean newDefaultCascadePersist) {
        boolean oldDefaultCascadePersist = this.defaultCascadePersist;
        this.defaultCascadePersist = newDefaultCascadePersist;
        this.firePropertyChanged("defaultCascadePersist", oldDefaultCascadePersist, newDefaultCascadePersist);
    }

    @Override
    public void addGenerator(Generator generator) {
        this.generators.add(generator);
    }

    @Override
    public ListIterator<Generator> allGenerators() {
        return new CloneListIterator(this.generators);
    }

    @Override
    public void addQuery(Query query) {
        this.queries.add(query);
    }

    @Override
    public ListIterator<Query> allQueries() {
        return new CloneListIterator(this.queries);
    }

    protected void initialize(XmlPersistenceUnit xmlPersistenceUnit) {
        this.xmlPersistenceUnit = xmlPersistenceUnit;
        this.name = xmlPersistenceUnit.getName();
        this.initializeSpecifiedClassRefs(xmlPersistenceUnit);
        this.initializeMappingFileRefs(xmlPersistenceUnit);
        this.initializeImpliedClassRefs(xmlPersistenceUnit);
        this.initializeProperties(xmlPersistenceUnit);
        this.initializePersistenceUnitDefaults();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.specifiedTransactionType = this.specifiedTransactionType(xmlPersistenceUnit);
        this.defaultTransactionType = this.defaultTransacationType();
        this.description = xmlPersistenceUnit.getDescription();
        this.provider = xmlPersistenceUnit.getProvider();
        this.jtaDataSource = xmlPersistenceUnit.getJtaDataSource();
        this.nonJtaDataSource = xmlPersistenceUnit.getNonJtaDataSource();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
    }

    protected void initializeMappingFileRefs(XmlPersistenceUnit xmlPersistenceUnit) {
        for (XmlMappingFileRef xmlMappingFileRef : xmlPersistenceUnit.getMappingFiles()) {
            this.specifiedMappingFileRefs.add(this.buildMappingFileRef(xmlMappingFileRef));
        }
        if (!this.impliedMappingFileIsSpecified() && this.impliedMappingFileExists()) {
            this.impliedMappingFileRef = this.buildMappingFileRef(null);
        }
    }

    protected void initializeSpecifiedClassRefs(XmlPersistenceUnit xmlPersistenceUnit) {
        for (XmlJavaClassRef xmlJavaClassRef : xmlPersistenceUnit.getClasses()) {
            this.specifiedClassRefs.add(this.buildClassRef(xmlJavaClassRef));
        }
    }

    protected void initializeImpliedClassRefs(XmlPersistenceUnit xmlPersistenceUnit) {
        if (this.getJpaProject().discoversAnnotatedClasses() && !this.isExcludeUnlistedClasses()) {
            for (String typeName : CollectionTools.iterable(this.getJpaProject().annotatedClassNames())) {
                if (this.classIsSpecified(typeName)) continue;
                this.impliedClassRefs.add(this.buildClassRef(typeName));
            }
        }
    }

    protected void initializeProperties(XmlPersistenceUnit xmlPersistenceUnit) {
        XmlProperties xmlProperties = xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            return;
        }
        for (XmlProperty xmlProperty : xmlProperties.getProperties()) {
            this.properties.add(this.buildProperty(xmlProperty));
        }
    }

    protected void initializePersistenceUnitDefaults() {
        PersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        if (persistenceUnitDefaults != null) {
            this.defaultSchema = this.schema(persistenceUnitDefaults);
            this.defaultCatalog = this.catalog(persistenceUnitDefaults);
            this.defaultAccess = this.access(persistenceUnitDefaults);
            this.defaultCascadePersist = this.cascadePersist(persistenceUnitDefaults);
        } else {
            this.defaultSchema = null;
            this.defaultCatalog = null;
            this.defaultAccess = null;
            this.defaultCascadePersist = false;
        }
    }

    @Override
    public void update(XmlPersistenceUnit persistenceUnit) {
        this.xmlPersistenceUnit = persistenceUnit;
        this.generators.clear();
        this.queries.clear();
        this.updateName(persistenceUnit);
        this.updateSpecifiedTransactionType(persistenceUnit);
        this.updateDefaultTransactionType();
        this.updateDescription(persistenceUnit);
        this.updateProvider(persistenceUnit);
        this.updateJtaDataSource(persistenceUnit);
        this.updateNonJtaDataSource(persistenceUnit);
        this.updateSpecifiedClassRefs(persistenceUnit);
        this.updateMappingFileRefs(persistenceUnit);
        this.updateImpliedClassRefs();
        this.updateExcludeUnlistedClasses(persistenceUnit);
        this.updateProperties(persistenceUnit);
        this.updatePersistenceUnitDefaults();
        this.generatorRepositoryUpdated();
        this.queryRepositoryUpdated();
    }

    protected void updateName(XmlPersistenceUnit persistenceUnit) {
        this.setName(persistenceUnit.getName());
    }

    protected void updateSpecifiedTransactionType(XmlPersistenceUnit persistenceUnit) {
        this.setSpecifiedTransactionType(this.specifiedTransactionType(persistenceUnit));
    }

    protected PersistenceUnitTransactionType specifiedTransactionType(XmlPersistenceUnit persistenceUnit) {
        return PersistenceUnitTransactionType.fromXmlResourceModel(persistenceUnit.getTransactionType());
    }

    protected void updateDefaultTransactionType() {
        this.setDefaultTransactionType(this.defaultTransacationType());
    }

    protected PersistenceUnitTransactionType defaultTransacationType() {
        return null;
    }

    protected void updateDescription(XmlPersistenceUnit persistenceUnit) {
        this.setDescription(persistenceUnit.getDescription());
    }

    protected void updateProvider(XmlPersistenceUnit persistenceUnit) {
        this.setProvider(persistenceUnit.getProvider());
    }

    protected void updateJtaDataSource(XmlPersistenceUnit persistenceUnit) {
        this.setJtaDataSource(persistenceUnit.getJtaDataSource());
    }

    protected void updateNonJtaDataSource(XmlPersistenceUnit persistenceUnit) {
        this.setNonJtaDataSource(persistenceUnit.getNonJtaDataSource());
    }

    protected void updateMappingFileRefs(XmlPersistenceUnit persistenceUnit) {
        ListIterator<MappingFileRef> stream = this.specifiedMappingFileRefs();
        CloneIterator stream2 = new CloneIterator(persistenceUnit.getMappingFiles());
        while (stream.hasNext()) {
            MappingFileRef mappingFileRef = (MappingFileRef)stream.next();
            if (stream2.hasNext()) {
                mappingFileRef.update((XmlMappingFileRef)stream2.next());
                continue;
            }
            this.removeSpecifiedMappingFileRef_(mappingFileRef);
        }
        while (stream2.hasNext()) {
            this.addSpecifiedMappingFileRef_(this.buildMappingFileRef((XmlMappingFileRef)stream2.next()));
        }
        if (this.impliedMappingFileIsSpecified()) {
            if (this.impliedMappingFileRef != null) {
                this.unsetImpliedMappingFileRef();
            }
        } else if (this.impliedMappingFileExists()) {
            if (this.impliedMappingFileRef == null) {
                this.setImpliedMappingFileRef();
            }
            this.getImpliedMappingFileRef().update(null);
        } else if (this.impliedMappingFileRef != null) {
            this.unsetImpliedMappingFileRef();
        }
    }

    protected boolean impliedMappingFileIsSpecified() {
        String impliedMappingFile = "META-INF/orm.xml";
        for (MappingFileRef each : this.specifiedMappingFileRefs) {
            if (!impliedMappingFile.equals(each.getFileName())) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedMappingFileExists() {
        OrmArtifactEdit oae = OrmArtifactEdit.getArtifactEditForRead(this.getJpaProject().getProject());
        OrmResource or = oae.getResource(JptCorePlugin.getDefaultOrmXmlDeploymentURI(this.getJpaProject().getProject()));
        boolean exists = or != null && or.exists();
        oae.dispose();
        return exists;
    }

    protected MappingFileRef buildMappingFileRef(XmlMappingFileRef xmlMappingFileRef) {
        return this.getJpaFactory().buildMappingFileRef(this, xmlMappingFileRef);
    }

    protected void updateSpecifiedClassRefs(XmlPersistenceUnit persistenceUnit) {
        ListIterator<ClassRef> contextClassRefs = this.specifiedClassRefs();
        CloneIterator resourceClassRefs = new CloneIterator(persistenceUnit.getClasses());
        while (contextClassRefs.hasNext()) {
            ClassRef contextClassRef = (ClassRef)contextClassRefs.next();
            if (resourceClassRefs.hasNext()) {
                contextClassRef.update((XmlJavaClassRef)resourceClassRefs.next());
                continue;
            }
            this.removeSpecifiedClassRef_(contextClassRef);
        }
        while (resourceClassRefs.hasNext()) {
            this.addSpecifiedClassRef_(this.buildClassRef((XmlJavaClassRef)resourceClassRefs.next()));
        }
    }

    protected void updateImpliedClassRefs() {
        if (this.isExcludeUnlistedClasses()) {
            for (ClassRef classRef : CollectionTools.iterable(this.impliedClassRefs())) {
                this.removeImpliedClassRef(classRef);
            }
            return;
        }
        Iterator<String> annotatedClassNames = this.getJpaProject().annotatedClassNames();
        Collection impliedRefsToRemove = CollectionTools.collection(this.impliedClassRefs());
        ArrayList<ClassRef> impliedRefsToUpdate = new ArrayList<ClassRef>();
        while (annotatedClassNames.hasNext()) {
            String annotatedClassName = annotatedClassNames.next();
            boolean impliedRefFound = false;
            if (this.classIsSpecified(annotatedClassName)) continue;
            for (ClassRef classRef : impliedRefsToRemove) {
                if (!annotatedClassName.equals(classRef.getClassName())) continue;
                impliedRefsToRemove.remove(classRef);
                impliedRefsToUpdate.add(classRef);
                impliedRefFound = true;
                break;
            }
            if (impliedRefFound) continue;
            this.addImpliedClassRef(annotatedClassName);
        }
        for (ClassRef classRef : impliedRefsToRemove) {
            this.removeImpliedClassRef(classRef);
        }
        for (ClassRef classRef : impliedRefsToUpdate) {
            classRef.update(classRef.getClassName());
        }
    }

    protected ClassRef buildClassRef(XmlJavaClassRef xmlClassRef) {
        return this.getJpaFactory().buildClassRef((PersistenceUnit)this, xmlClassRef);
    }

    protected ClassRef buildClassRef(String className) {
        return this.getJpaFactory().buildClassRef((PersistenceUnit)this, className);
    }

    protected boolean classIsSpecified(String className) {
        for (ClassRef specifiedClassRef : CollectionTools.iterable(this.specifiedClassRefs())) {
            if (!className.equals(specifiedClassRef.getClassName())) continue;
            return true;
        }
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            if (mappingFileRef.getPersistentType(className) == null) continue;
            return true;
        }
        return false;
    }

    protected void updateExcludeUnlistedClasses(XmlPersistenceUnit persistenceUnit) {
        this.setSpecifiedExcludeUnlistedClasses(persistenceUnit.getExcludeUnlistedClasses());
    }

    protected void updateProperties(XmlPersistenceUnit persistenceUnit) {
        XmlProperties xmlProperties = persistenceUnit.getProperties();
        ListIterator<Property> stream = this.properties();
        Iterator stream2 = xmlProperties == null ? EmptyIterator.instance() : new CloneIterator(xmlProperties.getProperties());
        while (stream.hasNext()) {
            Property property = (Property)stream.next();
            if (stream2.hasNext()) {
                property.update((XmlProperty)stream2.next());
                continue;
            }
            this.removeProperty_(property);
        }
        while (stream2.hasNext()) {
            this.addProperty_(this.buildProperty((XmlProperty)stream2.next()));
        }
    }

    protected Property buildProperty(XmlProperty xmlProperty) {
        return this.getJpaFactory().buildProperty(this, xmlProperty);
    }

    protected void updatePersistenceUnitDefaults() {
        PersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        this.setDefaultSchema(this.schema(persistenceUnitDefaults));
        this.setDefaultCatalog(this.catalog(persistenceUnitDefaults));
        this.setDefaultAccess(this.access(persistenceUnitDefaults));
        this.setDefaultCascadePersist(this.cascadePersist(persistenceUnitDefaults));
    }

    protected String schema(PersistenceUnitDefaults persistenceUnitDefaults) {
        if (persistenceUnitDefaults != null && persistenceUnitDefaults.getSchema() != null) {
            return persistenceUnitDefaults.getSchema();
        }
        Schema projectDefaultSchema = this.projectDefaultSchema();
        return projectDefaultSchema == null ? null : projectDefaultSchema.getName();
    }

    protected Schema projectDefaultSchema() {
        return this.getJpaProject().getDefaultSchema();
    }

    protected String catalog(PersistenceUnitDefaults persistenceUnitDefaults) {
        if (persistenceUnitDefaults != null && persistenceUnitDefaults.getCatalog() != null) {
            return persistenceUnitDefaults.getCatalog();
        }
        return this.projectDefaultCatalogName();
    }

    protected String projectDefaultCatalogName() {
        Catalog catalog = this.getJpaProject().getConnectionProfile().getDefaultCatalog();
        return catalog == null ? null : catalog.getName();
    }

    protected AccessType access(PersistenceUnitDefaults persistenceUnitDefaults) {
        return persistenceUnitDefaults == null ? null : persistenceUnitDefaults.getAccess();
    }

    protected boolean cascadePersist(PersistenceUnitDefaults persistenceUnitDefaults) {
        return persistenceUnitDefaults == null ? false : persistenceUnitDefaults.isCascadePersist();
    }

    protected void generatorRepositoryUpdated() {
        this.fireListChanged("generators");
    }

    protected void queryRepositoryUpdated() {
        this.fireListChanged("queries");
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addMappingFileMessages(messages);
        this.addClassMessages(messages);
    }

    protected void addMappingFileMessages(List<IMessage> messages) {
        this.addMultipleMetadataMessages(messages);
        this.addDuplicateMappingFileMessages(messages);
        ListIterator<MappingFileRef> stream = this.mappingFileRefs();
        while (stream.hasNext()) {
            ((MappingFileRef)stream.next()).addToMessages(messages);
        }
    }

    protected void addMultipleMetadataMessages(List<IMessage> messages) {
        Collection<PersistenceUnitDefaults> puDefaultsCollection = this.persistenceUnitDefaultsForValidation();
        if (puDefaultsCollection.size() > 1) {
            for (PersistenceUnitDefaults puDefaults : puDefaultsCollection) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_MAPPINGS_MULTIPLE_METADATA", new String[]{this.getName()}, puDefaults));
            }
        }
    }

    protected void addDuplicateMappingFileMessages(List<IMessage> messages) {
        HashBag fileBag = new HashBag(CollectionTools.collection((Iterator)new TransformationIterator<MappingFileRef, String>(this.mappingFileRefs()){

            protected String transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.getFileName();
            }
        }));
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            if (fileBag.count((Object)mappingFileRef.getFileName()) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE", new String[]{mappingFileRef.getFileName()}, mappingFileRef, mappingFileRef.getValidationTextRange()));
        }
    }

    protected void addClassMessages(List<IMessage> messages) {
        this.addDuplicateClassMessages(messages);
        for (ClassRef classRef : CollectionTools.iterable(this.classRefs())) {
            classRef.addToMessages(messages);
        }
    }

    protected void addDuplicateClassMessages(List<IMessage> messages) {
        HashBag classNameBag = new HashBag(CollectionTools.collection((Iterator)new TransformationIterator<ClassRef, String>(this.classRefs()){

            protected String transform(ClassRef classRef) {
                return classRef.getClassName();
            }
        }));
        for (ClassRef javaClassRef : CollectionTools.iterable(this.classRefs())) {
            if (javaClassRef.getClassName() == null || classNameBag.count((Object)javaClassRef.getClassName()) <= 1) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_CLASS", new String[]{javaClassRef.getClassName()}, javaClassRef, javaClassRef.getValidationTextRange()));
        }
    }

    private Collection<PersistenceUnitDefaults> persistenceUnitDefaultsForValidation() {
        ArrayList<PersistenceUnitDefaults> puDefaults = new ArrayList<PersistenceUnitDefaults>();
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            PersistenceUnitDefaults persistenceUnitDefaults = mappingFileRef.getPersistenceUnitDefaults();
            if (persistenceUnitDefaults == null) continue;
            puDefaults.add(persistenceUnitDefaults);
        }
        return puDefaults;
    }

    @Override
    public PersistentType getPersistentType(String fullyQualifiedTypeName) {
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            OrmPersistentType ormPersistentType = mappingFileRef.getPersistentType(fullyQualifiedTypeName);
            if (ormPersistentType == null) continue;
            return ormPersistentType;
        }
        for (ClassRef classRef : CollectionTools.iterable(this.classRefs())) {
            if (!classRef.isFor(fullyQualifiedTypeName)) continue;
            return classRef.getJavaPersistentType();
        }
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            if (!mappingFileRef.containsOffset(textOffset)) continue;
            return mappingFileRef;
        }
        for (ClassRef classRef : CollectionTools.iterable(this.classRefs())) {
            if (!classRef.containsOffset(textOffset)) continue;
            return classRef;
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.xmlPersistenceUnit == null) {
            return false;
        }
        return this.xmlPersistenceUnit.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistenceUnit.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlPersistenceUnit.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }

    @Override
    public void dispose() {
        for (ClassRef classRef : CollectionTools.iterable(this.classRefs())) {
            classRef.dispose();
        }
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(this.mappingFileRefs())) {
            mappingFileRef.dispose();
        }
    }
}

