/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.customization;

import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Customization;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCustomizerProperties
extends AbstractModel {
    private Customization customization;
    private String entityName;
    public static final String DESCRIPTOR_CUSTOMIZER_PROPERTY = "descriptorCustomizerProperty";
    SimplePropertyValueModel<Customization> customizationHolder;
    PropertyValueModel<String> descriptorCustomizerHolder;
    PropertyChangeListener descriptorCustomizerListener;
    private static final long serialVersionUID = 1L;

    public EntityCustomizerProperties(Customization customization, String entityName) {
        this.customization = customization;
        this.entityName = entityName;
        this.customizationHolder = new SimplePropertyValueModel((Object)this.customization);
        this.descriptorCustomizerHolder = this.buildDescriptorCustomizerAA((PropertyValueModel<Customization>)this.customizationHolder);
        this.descriptorCustomizerListener = this.buildDescriptorCustomizerChangeListener();
        this.descriptorCustomizerHolder.addPropertyChangeListener("value", this.descriptorCustomizerListener);
    }

    public boolean entityNameIsValid() {
        return !StringTools.stringIsEmpty((String)this.entityName);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDescriptorCustomizer() {
        return this.customization.getDescriptorCustomizer(this.entityName);
    }

    public String getDefaultDescriptorCustomizer() {
        return this.customization.getDefaultDescriptorCustomizer();
    }

    public void setDescriptorCustomizer(String descriptorCustomizer) {
        String old = this.getDescriptorCustomizer();
        if (this.attributeValueHasChanged(old, descriptorCustomizer)) {
            this.customization.setDescriptorCustomizer(descriptorCustomizer, this.entityName);
            this.firePropertyChanged(DESCRIPTOR_CUSTOMIZER_PROPERTY, old, descriptorCustomizer);
        }
    }

    public JpaProject getJpaProject() {
        return this.customization.getJpaProject();
    }

    private PropertyValueModel<String> buildDescriptorCustomizerAA(PropertyValueModel<Customization> subjectHolder) {
        return new PropertyAspectAdapter<Customization, String>(subjectHolder, new String[]{DESCRIPTOR_CUSTOMIZER_PROPERTY}){

            protected String buildValue_() {
                return ((Customization)this.subject).getDescriptorCustomizer(EntityCustomizerProperties.this.entityName);
            }
        };
    }

    private PropertyChangeListener buildDescriptorCustomizerChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                EntityCustomizerProperties.this.descriptorCustomizerChanged(e);
            }
        };
    }

    protected void descriptorCustomizerChanged(PropertyChangeEvent e) {
        String old = (String)e.getOldValue();
        String newDescriptorCustomizer = (String)e.getNewValue();
        this.firePropertyChanged(DESCRIPTOR_CUSTOMIZER_PROPERTY, old, newDescriptorCustomizer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn((Object)((Object)this), (StringBuilder)sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append("name: ");
        sb.append(this.entityName);
        sb.append(", descriptorCustomizer: ");
        sb.append(this.getDescriptorCustomizer());
    }
}

