/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.border.CompoundBorder;
import javax.swing.border.SoftBevelBorder;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;

public class BorderTest
extends AbstractInitParserTestCase {
    public BorderTest(String name) {
        super(name);
    }

    public void testEtchedRaised() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED)", BorderFactory.createEtchedBorder(0));
    }

    public void testBevelRaised() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED)", BorderFactory.createBevelBorder(0));
    }

    public void testEmpty() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createEmptyBorder()", BorderFactory.createEmptyBorder());
    }

    public void testMatte() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createMatteBorder(2, 2, 2, 2, java.awt.Color.black)", false, BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
    }

    public void testSoftBevel() throws Throwable {
        this.testHelper.testInitString("new javax.swing.border.SoftBevelBorder(0)", false, new SoftBevelBorder(0));
    }

    public void testEmptySize() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2)", false, BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void testLine() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createLineBorder(java.awt.Color.black, 2)", false, BorderFactory.createLineBorder(Color.black, 2));
    }

    public void testSoftBevelRaised() throws Throwable {
        this.testHelper.testInitString("new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED)", false, new SoftBevelBorder(0));
    }

    public void testTitledBasic() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createTitledBorder(null,\"frog\",2,0)", false, BorderFactory.createTitledBorder(null, "frog", 2, 0));
    }

    public void testCompoundBasic() throws Throwable {
        this.testHelper.testInitString("new javax.swing.border.CompoundBorder(javax.swing.BorderFactory.createEmptyBorder(),javax.swing.BorderFactory.createEmptyBorder())", false, new CompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder()));
    }

    public void testCompoundMedium() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED), javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED))", false, BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createBevelBorder(1)));
    }

    public void testTitledAdvanced() throws Throwable {
        this.testHelper.testInitString("javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(java.awt.SystemColor.activeCaption,30), \"Hello\", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font(\"Dialog\", java.awt.Font.BOLD, 18), java.awt.Color.lightGray)", false, BorderFactory.createTitledBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 30), "Hello", 2, 0, new Font("Dialog", 1, 18), Color.lightGray));
    }
}

