/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser.tree;

import java.awt.Color;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;
import org.eclipse.jem.tests.proxy.initParser.tree.ASTTreeInitStringParserTestHelper;

public class ASTOperationsTest
extends AbstractInitParserTestCase {
    public ASTOperationsTest(String name) {
        super(name);
    }

    protected ASTTreeInitStringParserTestHelper getTreeParser() {
        return (ASTTreeInitStringParserTestHelper)this.testHelper;
    }

    public void testTwoOpers() throws Throwable {
        this.testHelper.testInitString("3+4", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith(7));
    }

    public void testFourOpersExtended() throws Throwable {
        this.testHelper.testInitString("3+4+5+6", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith(18));
    }

    public void testMixedOpers() throws Throwable {
        this.testHelper.testInitString("3+4-5", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith(2));
    }

    public void testMixedOpersPrecedence() throws Throwable {
        this.testHelper.testInitString("6 | 3+4 | 8", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith(15));
    }

    public void testConditional() throws Throwable {
        this.testHelper.testInitString("java.awt.Color.red != null ? 3 : 5", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith(Color.red != null ? 3 : 5));
    }

    public void testInstanceof() throws Throwable {
        this.testHelper.testInitString("java.awt.Color.red instanceof java.awt.Color", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith(true));
    }

    public void testTypeLiteral() throws Throwable {
        this.testHelper.testInitString("Object.class", this.getTreeParser().getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.lang.Object"));
    }

    public void testStringPlusOperations() throws Throwable {
        this.testHelper.testInitString("3+\"a\"", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith("3a"));
    }

    public void testStringPlusOperations1() throws Throwable {
        this.testHelper.testInitString("\"a\"+3", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith("a3"));
    }

    public void testStringPlusExtendedOperations() throws Throwable {
        this.testHelper.testInitString("3+4+\"a\"", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith("7a"));
    }

    public void testStringPlusExtendedOperations1() throws Throwable {
        this.testHelper.testInitString("3+\"a\"+4", this.getTreeParser().getRegistry().getBeanProxyFactory().createBeanProxyWith("3a4"));
    }
}

