/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.junit;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.validation.test.internal.registry.OperationTestcase;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.internal.util.BVTValidationUtility;
import org.eclipse.jst.validation.test.junit.OperationSuite;
import org.eclipse.jst.validation.test.junit.OperationTest;
import org.eclipse.jst.validation.test.junit.ValidatorSuite;
import org.eclipse.jst.validation.test.junit.ValidatorTest;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public class BVTSuite
extends TestSuite {
    private Map _validatorSuites = new HashMap();

    public BVTSuite() {
        this.loadValidatorSuites();
        this.loadOperationSuites();
    }

    private void loadValidatorSuites() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidatorTestcase[] tmds = BVTValidationUtility.getValidatorTests((IProgressMonitor)monitor);
        int i = 0;
        while (i < tmds.length) {
            ValidatorTestcase tmd = tmds[i];
            if (tmd.isVisible()) {
                ValidatorMetaData vmd = tmd.getValidatorMetaData();
                ValidatorSuite vs = (ValidatorSuite)((Object)this._validatorSuites.get(vmd));
                if (vs == null) {
                    vs = new ValidatorSuite(vmd);
                }
                ValidatorTest vt = new ValidatorTest(tmd, vs);
                vs.addTest((Test)vt);
                this._validatorSuites.put(vmd, vs);
            }
            ++i;
        }
        for (ValidatorSuite vs : this._validatorSuites.values()) {
            this.addTest((Test)vs);
        }
    }

    private void loadOperationSuites() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        OperationTestcase[] tmds = BVTValidationUtility.getOperationTests((IProgressMonitor)monitor);
        OperationSuite os = new OperationSuite();
        int i = 0;
        while (i < tmds.length) {
            OperationTestcase tmd = tmds[i];
            if (tmd.isVisible()) {
                OperationTest ot = new OperationTest(tmd, os);
                os.addTest((Test)ot);
            }
            ++i;
        }
        this.addTest((Test)os);
    }

    public static Test suite() {
        return new BVTSuite();
    }

    public String toString() {
        return "Validation BVT Suite";
    }
}

