/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.performance;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jst.jsp.ui.internal.style.LineStyleProviderForJSP;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForEmbeddedCSS;
import org.eclipse.wst.html.ui.internal.style.LineStyleProviderForHTML;
import org.eclipse.wst.javascript.ui.internal.common.style.LineStyleProviderForJavaScript;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class TestHighlighterPerformance
extends PerformanceTestCase {
    public TestHighlighterPerformance(String name) {
        super(name);
    }

    public void testHighlightBigStyle() throws IOException {
        this.startMeasuring();
        this.doHighlighterTest("bigStyle.jsp");
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testHighlight300kJSP() throws IOException {
        this.startMeasuring();
        this.doHighlighterTest("testfiles/company300k.jsp");
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void doHighlighterTest(String filename) throws IOException {
        this.doHighligtherTest(filename, 0);
    }

    protected void doHighligtherTest(String filename, int start) throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        IStructuredDocument sDoc = modelManager.createStructuredDocumentFor(filename, inStream, null);
        int end = sDoc.getText().length();
        this.doHighlighterTest(filename, start, end);
    }

    protected void doHighlighterTest(String filename, int start, int end) throws IOException {
        this.doNewHighlighterTest(filename, start, end);
    }

    /*
     * Exception decompiling
     */
    protected void doNewHighlighterTest(String filename, int start, int end) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 460->464)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IHighlighter getAppropriateHighlighter(String filename) {
        IHighlighter result = null;
        if (filename.endsWith(".jsp")) {
            result = this.getHighlighterJSP();
        }
        return result;
    }

    private IHighlighter getHighlighterJSP() {
        Highlighter highlighter = new Highlighter();
        if (highlighter != null) {
            LineStyleProviderForHTML htmlLineStyleProvider = new LineStyleProviderForHTML();
            highlighter.addProvider("org.eclipse.wst.html.HTML_DEFAULT", (LineStyleProvider)htmlLineStyleProvider);
            highlighter.addProvider("org.eclipse.wst.html.HTML_COMMENT", (LineStyleProvider)htmlLineStyleProvider);
            highlighter.addProvider("org.eclipse.wst.html.HTML_DECLARATION", (LineStyleProvider)htmlLineStyleProvider);
            LineStyleProviderForJavaScript jsLineStyleProvider = new LineStyleProviderForJavaScript();
            highlighter.addProvider("org.eclipse.wst.html.SCRIPT", (LineStyleProvider)jsLineStyleProvider);
            LineStyleProviderForEmbeddedCSS cssLineStyleProvider = new LineStyleProviderForEmbeddedCSS();
            highlighter.addProvider("org.eclipse.wst.css.STYLE", (LineStyleProvider)cssLineStyleProvider);
            LineStyleProviderForJSP jspLineStyleProvider = new LineStyleProviderForJSP();
            highlighter.addProvider("org.eclipse.jst.jsp.DEFAULT_JSP", (LineStyleProvider)jspLineStyleProvider);
            highlighter.addProvider("org.eclipse.jst.jsp.JSP_COMMENT", (LineStyleProvider)jspLineStyleProvider);
            highlighter.addProvider("org.eclipse.jst.jsp.JSP_DIRECTIVE", (LineStyleProvider)jspLineStyleProvider);
            highlighter.addProvider("org.eclipse.jst.jsp.SCRIPT.DELIMITER", (LineStyleProvider)jspLineStyleProvider);
            highlighter.addProvider("org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT", (LineStyleProvider)new LineStyleProviderForJavaScript());
        }
        return highlighter;
    }
}

