/*
** Copyright (c) Oracle Corporation 2005. All Rights Reserved.
**
**345678901234567890123456789012345678901234567890123456789012345678901234567890
*/

package oracle.adfdemo.view.faces.convertValidate;


import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import oracle.adf.view.faces.validator.ClientValidator;
import oracle.adf.view.faces.util.LabeledFacesMessage;

/**
 * <p>Password validator - this is an incredibly simple
 * password validator that makes sure there's at least one number
 * in the password.</p>
 *
 */
public class PasswordValidator implements Validator, ClientValidator
{
  public static final String VALIDATOR_ID = "oracle.adfdemo.PasswordValidator";

  public void validate(
    FacesContext context,
    UIComponent component,
    Object value) throws ValidatorException
  {

    String password = "";

    if ( value != null)
      password = value.toString().trim();

    for (int j = 0;j < password.length();j++)
    {
      if (Character.isDigit(password.charAt(j)))
      {
        return;
      }
    }

    // Using the LabeledFacesMessage allows the <af:messages> component to
    // properly prepend the label as a link.
    LabeledFacesMessage lfm =
      new LabeledFacesMessage(FacesMessage.SEVERITY_ERROR,
                              "Validation Error",
                              "The password must contain at least one number");
    lfm.setLabel(_getLabel(component));
    throw new ValidatorException(lfm);
  }


  public String getClientValidation(
    FacesContext context,
   UIComponent component)
  {
    return (_VALIDATOR_INSTANCE_STRING);
  }


  public String getClientScript(
   FacesContext context,
   UIComponent component)
  {
    // check if the script has already been returned this request
    Object scriptReturned =
                context.getExternalContext().getRequestMap().get(VALIDATOR_ID);

    // if scriptReturned is null the script hasn't been returned yet
    if ( scriptReturned == null)
    {
      context.getExternalContext().getRequestMap().put(VALIDATOR_ID,
                                                       Boolean.TRUE);
      return  _sPasswordValidatorJS;
    }
    // if scriptReturned is not null, then script has already been returned,
    // so don't return it again.
    else
      return null;

   }

  private static Object _getLabel(UIComponent component)
  {
    Object o = null;
    if (component != null)
    {
      o = component.getAttributes().get("label");
      if (o == null)
        o = component.getValueBinding("label");
    }
    return o;
  }

  // in a real app the messages would be translated
  // The fourth field marker gets the field label
  private static final String _VALIDATOR_INSTANCE_STRING =
    "new PasswordValidator({"
    + "N:'{0} - The password value must contain at least one number.'})";

  private static final String _sPasswordValidatorJS =
    "function passwordValidate(value)" +
       "{if (!value)return void (0);" +
        "var messageKey = PasswordValidator.NUMBER;" +
        "for (var i = 0; i < value.length; i++)" +
        "{var subValue = value.substring(i, i+1);" +
         "if (!isNaN(parseInt(subValue))){" +
            "messageKey = void (0);break;}}" +
        "if (messageKey != void(0))" +
          "return new ValidatorException(this._messages[messageKey]);" +
        "return void(0);}" +
    "function PasswordValidator(messages)" +
      "{this._messages = messages;}" +
    "PasswordValidator.prototype = new Validator();" +
    "PasswordValidator.prototype.validate = passwordValidate;" +
    "PasswordValidator.NUMBER = 'N';" ;
}
