/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contenttype;

import java.util.EmptyStackException;

public class BooleanStack {
    private boolean[] list = null;
    private int size = 0;
    public static int maxDepth = 100;

    public BooleanStack() {
        this(maxDepth);
    }

    public BooleanStack(int maxdepth) {
        this.list = new boolean[maxdepth];
        this.initialize();
    }

    public void clear() {
        this.initialize();
    }

    public boolean empty() {
        return this.size == 0;
    }

    public boolean get(int slot) {
        return this.list[slot];
    }

    private void initialize() {
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = false;
            ++i;
        }
    }

    public boolean peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.list[this.size - 1];
    }

    public boolean pop() {
        boolean value = this.peek();
        this.list[this.size - 1] = false;
        --this.size;
        return value;
    }

    public boolean push(boolean newValue) {
        if (this.size == this.list.length) {
            throw new StackOverflowError();
        }
        this.list[this.size++] = newValue;
        return newValue;
    }

    public int size() {
        return this.list.length;
    }

    public static void setMaxDepth(int depth) {
    }
}

