/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceClientImpl;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntimeChecker;

public class ClientRuntimeDescriptor {
    private IConfigurationElement elem;
    private Hashtable allWebServiceClientImpls;
    private Hashtable allRuntimes;
    private String id;
    private WebServiceClientImpl clientImplementationType;
    private RuntimeDescriptor runtime;
    private String clientRuntimeClassName;
    private IWebServiceRuntime webServiceRuntime;
    private RequiredFacetVersion[] requiredFacetVersions;
    private Set projectFacetVersions;
    private IWebServiceRuntimeChecker webServiceRuntimeChecker;
    private String runtimePreferredServerType;

    public ClientRuntimeDescriptor(IConfigurationElement elem, Hashtable allWebServiceClientImpls, Hashtable allRuntimes) {
        this.elem = elem;
        this.allWebServiceClientImpls = allWebServiceClientImpls;
        this.allRuntimes = allRuntimes;
    }

    public WebServiceClientImpl getClientImplementationType() {
        if (this.clientImplementationType == null) {
            String clientImplementationTypeId = this.elem.getAttribute("clientImplementationTypeId");
            this.clientImplementationType = (WebServiceClientImpl)this.allWebServiceClientImpls.get(clientImplementationTypeId);
        }
        return this.clientImplementationType;
    }

    public String getClientRuntimeClassName() {
        if (this.clientRuntimeClassName == null) {
            this.clientRuntimeClassName = this.elem.getAttribute("class");
        }
        return this.clientRuntimeClassName;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.elem.getAttribute("id");
        }
        return this.id;
    }

    public RequiredFacetVersion[] getRequiredFacetVersions() {
        if (this.requiredFacetVersions == null) {
            ArrayList<RequiredFacetVersion> requiredFacetVersionList = new ArrayList<RequiredFacetVersion>();
            IConfigurationElement[] facetElems = this.elem.getChildren("required-facet-version");
            int i = 0;
            while (i < facetElems.length) {
                RequiredFacetVersion rfv = new RequiredFacetVersion();
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)facetElems[i].getAttribute("facet"));
                IProjectFacetVersion projectFacetVersion = projectFacet.getVersion(facetElems[i].getAttribute("version"));
                rfv.setProjectFacetVersion(projectFacetVersion);
                String allowNewerValue = facetElems[i].getAttribute("allow-newer");
                if (allowNewerValue == null) {
                    rfv.setAllowNewer(false);
                } else {
                    rfv.setAllowNewer(Boolean.valueOf(allowNewerValue).booleanValue());
                }
                requiredFacetVersionList.add(rfv);
                ++i;
            }
            this.requiredFacetVersions = requiredFacetVersionList.toArray(new RequiredFacetVersion[0]);
        }
        return this.requiredFacetVersions;
    }

    public Set getProjectFacetVersions() {
        if (this.projectFacetVersions == null) {
            this.projectFacetVersions = new HashSet();
            RequiredFacetVersion[] rfv = this.getRequiredFacetVersions();
            int i = 0;
            while (i < rfv.length) {
                this.projectFacetVersions.add(rfv[i].getProjectFacetVersion());
                ++i;
            }
        }
        return this.projectFacetVersions;
    }

    public RuntimeDescriptor getRuntime() {
        if (this.runtime == null) {
            String runtimeId = this.elem.getAttribute("runtimeId");
            this.runtime = (RuntimeDescriptor)this.allRuntimes.get(runtimeId);
        }
        return this.runtime;
    }

    public IWebServiceRuntime getWebServiceRuntime() {
        if (this.webServiceRuntime == null) {
            try {
                this.webServiceRuntime = (IWebServiceRuntime)this.elem.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return this.webServiceRuntime;
    }

    public IWebServiceRuntimeChecker getClientRuntimeChecker() {
        if (this.webServiceRuntimeChecker == null) {
            try {
                if (this.elem.getAttribute("runtimeChecker") != null) {
                    this.webServiceRuntimeChecker = (IWebServiceRuntimeChecker)this.elem.createExecutableExtension("runtimeChecker");
                }
            }
            catch (CoreException coreException) {}
        }
        return this.webServiceRuntimeChecker;
    }

    public String getRuntimePreferredServerType() {
        if (this.runtimePreferredServerType == null) {
            this.runtimePreferredServerType = this.elem.getAttribute("runtimePreferredServerType");
        }
        return this.runtimePreferredServerType;
    }
}

