/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.util.XMLChar;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.MultiplicitySection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDDirectivesManager;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.w3c.dom.Element;

public class XSDModelGroupDefinitionSection
extends MultiplicitySection {
    protected Text nameText;
    protected CCombo componentNameCombo;
    boolean isReference;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        if (this.isReference) {
            GridData data = new GridData();
            data.horizontalAlignment = 32;
            data.grabExcessHorizontalSpace = false;
            CLabel refLabel = this.getWidgetFactory().createCLabel(this.composite, "ref:");
            refLabel.setLayoutData((Object)data);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            this.componentNameCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
            this.componentNameCombo.addSelectionListener((SelectionListener)this);
            this.componentNameCombo.setLayoutData((Object)data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.componentNameCombo, "org.eclipse.wst.xsd.ui.xsdup0430");
            this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_MINOCCURS);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            this.minCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
            this.minCombo.setLayoutData((Object)data);
            this.minCombo.add("0");
            this.minCombo.add("1");
            this.applyAllListeners((Control)this.minCombo);
            this.minCombo.addSelectionListener((SelectionListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.minCombo, "org.eclipse.wst.xsd.ui.xsdup0180");
            this.getWidgetFactory().createCLabel(this.composite, org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_MAXOCCURS);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            this.maxCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
            this.maxCombo.setLayoutData((Object)data);
            this.maxCombo.add("0");
            this.maxCombo.add("1");
            this.maxCombo.add("unbounded");
            this.applyAllListeners((Control)this.maxCombo);
            this.maxCombo.addSelectionListener((SelectionListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.maxCombo, "org.eclipse.wst.xsd.ui.xsdup0190");
        } else {
            GridData data = new GridData();
            data.horizontalAlignment = 32;
            data.grabExcessHorizontalSpace = false;
            CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_NAME);
            nameLabel.setLayoutData((Object)data);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            this.nameText = this.getWidgetFactory().createText(this.composite, "");
            this.nameText.setLayoutData((Object)data);
            this.applyAllListeners((Control)this.nameText);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, "org.eclipse.wst.xsd.ui.xsdup0350");
            this.createRenameHyperlink(this.composite);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        this.setListenerEnabled(false);
        XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
        if (this.isReference) {
            Element element = namedComponent.getElement();
            if (element != null) {
                String attrValue = element.getAttribute("ref");
                if (attrValue == null) {
                    attrValue = "";
                }
                this.componentNameCombo.setText(attrValue);
                if (this.minCombo != null && this.maxCombo != null) {
                    this.refreshMinMax();
                }
            }
        } else {
            this.nameText.setText("");
            String name = namedComponent.getName();
            if (name != null) {
                this.nameText.setText(name);
            }
        }
        this.setListenerEnabled(true);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.init();
        this.relayout();
        if (this.isReference) {
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            List<String> items = new ArrayList();
            items = helper.getModelGroups();
            if (this.input instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition group = (XSDModelGroupDefinition)this.input;
                XSDConcreteComponent parent = group.getContainer();
                while (parent != null) {
                    if (parent instanceof XSDModelGroupDefinition) {
                        items.remove(((XSDModelGroupDefinition)parent).getQName());
                        break;
                    }
                    parent = parent.getContainer();
                }
            }
            items.add(0, "");
            this.componentNameCombo.setItems(items.toArray(new String[0]));
        }
    }

    protected void init() {
        if (this.input instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)this.input;
            this.isReference = group.isModelGroupDefinitionReference();
        }
    }

    protected void relayout() {
        Composite parentComposite = this.composite.getParent();
        parentComposite.getParent().setRedraw(false);
        if (parentComposite != null && !parentComposite.isDisposed()) {
            Control[] children = parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createContents(parentComposite);
        parentComposite.getParent().layout(true, true);
        parentComposite.getParent().setRedraw(true);
        this.refresh();
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.nameText) {
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(Messages._UI_ACTION_RENAME, namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.componentNameCombo) {
            String newValue = this.componentNameCombo.getText();
            if (this.input instanceof XSDNamedComponent) {
                XSDNamedComponent namedComponent = (XSDNamedComponent)this.input;
                Element element = namedComponent.getElement();
                if (namedComponent instanceof XSDModelGroupDefinition) {
                    element.setAttribute("ref", newValue);
                    XSDDirectivesManager.removeUnusedXSDImports(namedComponent.getSchema());
                }
            }
        }
        super.doWidgetSelected(e);
    }

    public void dispose() {
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.removeListeners((Control)this.nameText);
        }
        super.dispose();
    }
}

