/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.util.IFilter;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.ProjectFacetsUiManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyFacetedProjectWizard
extends Wizard {
    private IFacetedProjectWorkingCopy fpjwc;
    private final WizardContext context = new WizardContext();
    private boolean showFacetsSelectionPage;
    private FacetsSelectionPage facetsSelectionPage;
    private FacetPages[] facetPages = new FacetPages[0];
    private Composite pageContainer;
    private final List<IWizardPage> pagesToDispose = new ArrayList<IWizardPage>();
    private final List<Runnable> delayedActions;
    private final List<Runnable> onDisposeActions;
    private final boolean disposeWorkingCopy;

    public ModifyFacetedProjectWizard() {
        this((IFacetedProject)null);
    }

    public ModifyFacetedProjectWizard(IFacetedProject fproj) {
        this(fproj == null ? FacetedProjectFramework.createNewProject() : fproj.createWorkingCopy(), true);
    }

    public ModifyFacetedProjectWizard(IFacetedProjectWorkingCopy fpjwc) {
        this(fpjwc, false);
    }

    private ModifyFacetedProjectWizard(IFacetedProjectWorkingCopy fpjwc, boolean disposeWorkingCopy) {
        try {
            this.fpjwc = fpjwc;
            this.delayedActions = new ArrayList<Runnable>();
            this.onDisposeActions = new ArrayList<Runnable>();
            this.disposeWorkingCopy = disposeWorkingCopy;
            this.facetsSelectionPage = null;
            this.showFacetsSelectionPage = true;
            this.setNeedsProgressMonitor(true);
            this.setForcePreviousAndNextButtons(true);
            this.setWindowTitle(Resources.wizardTitle);
        }
        catch (RuntimeException e) {
            FacetUiPlugin.log(e);
            throw e;
        }
    }

    public final IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return this.fpjwc;
    }

    public void setFacetedProjectWorkingCopy(IFacetedProjectWorkingCopy fpjwc) {
        this.fpjwc = fpjwc;
    }

    public final IFacetedProject getFacetedProject() {
        String projectName;
        IFacetedProject fproj = this.fpjwc.getFacetedProject();
        if (fproj == null && (projectName = this.fpjwc.getProjectName()) != null) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                fproj = ProjectFacetsManager.create((IProject)proj);
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        return fproj;
    }

    public void addPages() {
        final IFacetedProjectListener listener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ModifyFacetedProjectWizard.this.handleSelectedFacetsChangedEvent();
                    }
                };
                Display.getDefault().asyncExec(runnable);
            }
        };
        this.fpjwc.addListener(listener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        this.onDisposeActions.add(new Runnable(){

            public void run() {
                ModifyFacetedProjectWizard.this.fpjwc.removeListener(listener);
            }
        });
        if (this.getShowFacetsSelectionPage()) {
            this.facetsSelectionPage = new FacetsSelectionPage(this.getBaseFacets(), this.fpjwc);
            this.addPage((IWizardPage)this.facetsSelectionPage);
        }
    }

    public int getPageCount() {
        return this.getPages().length;
    }

    public IWizardPage[] getPages() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.facetsSelectionPage != null) {
            list.add((Object)this.facetsSelectionPage);
        }
        int i = 0;
        while (i < this.facetPages.length) {
            list.addAll(this.facetPages[i].pages);
            ++i;
        }
        return list.toArray(new IWizardPage[list.size()]);
    }

    public IWizardPage getPage(String pageName) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.getName().equals(pageName)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getStartingPage() {
        return this.getPages()[0];
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == pages.length - 1) {
            return null;
        }
        return pages[pos + 1];
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == 0) {
            return null;
        }
        return pages[pos - 1];
    }

    public boolean canFinish() {
        if (this.facetsSelectionPage != null && !this.facetsSelectionPage.isPageComplete()) {
            return false;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        this.pageContainer = container;
        this.handleSelectedFacetsChangedEvent();
        this.executeDelayedActions();
    }

    public boolean performFinish() {
        int i = 0;
        while (i < this.facetPages.length) {
            for (IFacetWizardPage fp : this.facetPages[i].pages) {
                fp.transferStateToConfig();
            }
            ++i;
        }
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ModifyFacetedProjectWizard.this.performFinish(monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof CoreException) {
                IStatus st = ((CoreException)te).getStatus();
                ErrorDialog.openError((Shell)this.getShell(), (String)Resources.errDlgTitle, (String)st.getMessage(), (IStatus)st);
                FacetUiPlugin.log(st);
            }
            throw new RuntimeException(e.getTargetException());
        }
        return true;
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        this.fpjwc.commitChanges(monitor);
    }

    public void syncWithPresetsModel(Combo combo) {
        ModifyFacetedProjectWizard.syncWithPresetsModel(this.fpjwc, combo);
    }

    public static void syncWithPresetsModel(IFacetedProjectWorkingCopy fpjwc, Combo combo) {
        ModifyFacetedProjectWizard.syncWithPresetsModel(fpjwc, combo, null);
    }

    public static void syncWithPresetsModel(final IFacetedProjectWorkingCopy fpjwc, final Combo combo, final IFilter<IPreset> filter) {
        final ArrayList sortedPresets = new ArrayList();
        final IFacetedProjectListener availablePresetsChangedListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = sortedPresets;
                        synchronized (list) {
                            sortedPresets.clear();
                            if (filter != null) {
                                for (IPreset preset : fpjwc.getAvailablePresets()) {
                                    if (!filter.check((Object)preset)) continue;
                                    sortedPresets.add(preset);
                                }
                            } else {
                                sortedPresets.addAll(fpjwc.getAvailablePresets());
                            }
                            Collections.sort(sortedPresets, new Comparator<IPreset>(){

                                @Override
                                public int compare(IPreset p1, IPreset p2) {
                                    if (p1 == p2) {
                                        return 0;
                                    }
                                    return p1.getLabel().compareTo(p2.getLabel());
                                }
                            });
                            IPreset selectedPreset = fpjwc.getSelectedPreset();
                            combo.removeAll();
                            combo.add(Resources.customPreset);
                            if (selectedPreset == null) {
                                combo.select(0);
                            }
                            for (IPreset preset : sortedPresets) {
                                combo.add(preset.getLabel());
                                if (selectedPreset == null || !preset.getId().equals(selectedPreset.getId())) continue;
                                combo.select(combo.getItemCount() - 1);
                            }
                        }
                    }
                };
                Display.getDefault().asyncExec(runnable);
            }
        };
        fpjwc.addListener(availablePresetsChangedListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.AVAILABLE_PRESETS_CHANGED});
        if (filter != null) {
            filter.addListener((IFilter.IFilterListener)new IFilter.IFilterListener<IPreset>(){

                public void handleEvent(IFilter.IFilterEvent<IPreset> event) {
                    availablePresetsChangedListener.handleEvent(null);
                }
            }, new IFilter.IFilterEvent.Type[]{IFilter.IFilterEvent.Type.FILTER_CHANGED});
        }
        final IFacetedProjectListener selectedPresetChangedListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = sortedPresets;
                        synchronized (list) {
                            IPreset preset = fpjwc.getSelectedPreset();
                            int index = preset == null ? -1 : sortedPresets.indexOf(preset);
                            combo.select(index + 1);
                        }
                    }
                };
                Display.getDefault().asyncExec(runnable);
            }
        };
        fpjwc.addListener(selectedPresetChangedListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED});
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                List list = sortedPresets;
                synchronized (list) {
                    int selection = combo.getSelectionIndex();
                    String presetId = selection == 0 ? null : ((IPreset)sortedPresets.get(selection - 1)).getId();
                    fpjwc.setSelectedPreset(presetId);
                }
            }
        });
        availablePresetsChangedListener.handleEvent(null);
        combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                fpjwc.removeListener(availablePresetsChangedListener);
                fpjwc.removeListener(selectedPresetChangedListener);
            }
        });
    }

    public void setCategoryExpandedState(final ICategory category, final boolean expanded) {
        if (this.facetsSelectionPage != null && this.facetsSelectionPage.panel != null) {
            this.facetsSelectionPage.panel.setCategoryExpandedState(category, true);
        } else {
            Runnable action = new Runnable(){

                public void run() {
                    ModifyFacetedProjectWizard.this.setCategoryExpandedState(category, expanded);
                }
            };
            this.delayedActions.add(action);
        }
    }

    public boolean getShowFacetsSelectionPage() {
        return this.showFacetsSelectionPage;
    }

    public void setShowFacetsSelectionPage(boolean showFacetsSelectionPage) {
        this.showFacetsSelectionPage = showFacetsSelectionPage;
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.facetPages.length) {
            this.pagesToDispose.addAll(this.facetPages[i].pages);
            ++i;
        }
        for (IWizardPage page : this.pagesToDispose) {
            page.dispose();
        }
        for (Runnable onDisposeAction : this.onDisposeActions) {
            try {
                onDisposeAction.run();
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }
        if (this.disposeWorkingCopy) {
            this.fpjwc.dispose();
        }
    }

    private void handleSelectedFacetsChangedEvent() {
        if (this.fpjwc.validate().getSeverity() == 4) {
            return;
        }
        Set<IProjectFacetVersion> base = this.getBaseFacets();
        Set actions = this.getFacetedProjectWorkingCopy().getProjectFacetActions();
        ArrayList sortedActions = new ArrayList(actions);
        ProjectFacetsManager.sort(base, sortedActions);
        ArrayList<FacetPages> newFacetPages = new ArrayList<FacetPages>();
        boolean[] markers = new boolean[this.facetPages.length];
        boolean changed = false;
        for (IFacetedProject.Action action : sortedActions) {
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            FacetPages fp = this.findFacetPages(action, markers);
            if (fp == null) {
                IActionDefinition actiondef;
                try {
                    actiondef = fv.getActionDefinition(base, action.getType());
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                    continue;
                }
                List<IFacetWizardPage> pages = ProjectFacetsUiManager.getWizardPages(actiondef.getId());
                if (!pages.isEmpty()) {
                    fp = new FacetPages();
                    fp.action = action;
                    fp.pages = pages;
                    for (IFacetWizardPage page : fp.pages) {
                        page.setWizard((IWizard)this);
                        page.setWizardContext(this.context);
                        page.setConfig(action.getConfig());
                        if (page.getControl() != null) continue;
                        page.createControl(this.pageContainer);
                        page.getControl().setVisible(false);
                    }
                    changed = true;
                }
            }
            if (fp == null) continue;
            newFacetPages.add(fp);
        }
        int i = 0;
        while (i < this.facetPages.length) {
            if (!markers[i]) {
                for (IFacetWizardPage page : this.facetPages[i].pages) {
                    page.setWizard(null);
                    this.pagesToDispose.add(page);
                }
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.facetPages = new FacetPages[newFacetPages.size()];
            newFacetPages.toArray(this.facetPages);
            this.pageContainer.layout(true, true);
            IWizardContainer wizardContainer = this.getContainer();
            if (wizardContainer.getCurrentPage() != null) {
                wizardContainer.updateButtons();
            }
        }
    }

    private FacetPages findFacetPages(IFacetedProject.Action action, boolean[] markers) {
        int i = 0;
        while (i < this.facetPages.length) {
            FacetPages fp = this.facetPages[i];
            if (fp.action == action) {
                markers[i] = true;
                return fp;
            }
            ++i;
        }
        return null;
    }

    private Set<IProjectFacetVersion> getBaseFacets() {
        IFacetedProject fproj = this.fpjwc.getFacetedProject();
        if (fproj == null) {
            return Collections.emptySet();
        }
        return fproj.getProjectFacets();
    }

    private void executeDelayedActions() {
        for (Runnable r : this.delayedActions) {
            try {
                r.run();
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }
    }

    private static final class FacetPages {
        public IFacetedProject.Action action;
        public List<IFacetWizardPage> pages;

        private FacetPages() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String wizardTitle;
        public static String errDlgTitle;
        public static String customPreset;

        static {
            Resources.initializeMessages((String)ModifyFacetedProjectWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WizardContext
    implements IWizardContext {
        private WizardContext() {
        }

        @Override
        public String getProjectName() {
            return ModifyFacetedProjectWizard.this.getFacetedProjectWorkingCopy().getProjectName();
        }

        @Override
        public Set<IProjectFacetVersion> getSelectedProjectFacets() {
            return ModifyFacetedProjectWizard.this.getFacetedProjectWorkingCopy().getProjectFacets();
        }

        @Override
        public boolean isProjectFacetSelected(IProjectFacetVersion fv) {
            return this.getSelectedProjectFacets().contains(fv);
        }

        @Override
        public Set<IFacetedProject.Action> getActions() {
            return ModifyFacetedProjectWizard.this.getFacetedProjectWorkingCopy().getProjectFacetActions();
        }

        @Override
        public IFacetedProject.Action getAction(IFacetedProject.Action.Type type, IProjectFacetVersion f) {
            for (IFacetedProject.Action action : this.getActions()) {
                if (action.getType() != type || action.getProjectFacetVersion() != f) continue;
                return action;
            }
            return null;
        }

        @Override
        public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) {
            IFacetedProject.Action action = this.getAction(type, fv);
            return action != null ? action.getConfig() : null;
        }
    }
}

