/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.compiler.util.ObjectVector;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.search.matching.PossibleMatch;

public class PossibleMatchSet {
    private SimpleLookupTable rootsToPossibleMatches = new SimpleLookupTable(5);
    private int elementCount = 0;
    private static final IPath VIRTUAL_RESOURCE = new Path("****&&VIRTUALRESOURCE&&*****");

    public void add(PossibleMatch possibleMatch) {
        IPath path = null;
        path = possibleMatch.document.isVirtual() ? VIRTUAL_RESOURCE : possibleMatch.openable.getPackageFragmentRoot().getPath();
        ObjectVector possibleMatches = (ObjectVector)this.rootsToPossibleMatches.get(path);
        if (possibleMatches != null) {
            if (possibleMatches.contains(possibleMatch)) {
                return;
            }
        } else {
            possibleMatches = new ObjectVector();
            this.rootsToPossibleMatches.put(path, possibleMatches);
        }
        possibleMatches.add(possibleMatch);
        ++this.elementCount;
    }

    public PossibleMatch[] getPossibleMatches(IPackageFragmentRoot[] roots) {
        Object[] result = new PossibleMatch[this.elementCount];
        int index = 0;
        ObjectVector virtualEntries = (ObjectVector)this.rootsToPossibleMatches.get(VIRTUAL_RESOURCE);
        if (virtualEntries != null) {
            virtualEntries.copyInto(result, index);
            index += virtualEntries.size();
        }
        int i = 0;
        int length = roots.length;
        while (i < length) {
            ObjectVector possibleMatches;
            if (!(roots[i].getPath() != null && roots[i].getPath().isEmpty() || (possibleMatches = (ObjectVector)this.rootsToPossibleMatches.get(roots[i].getPath())) == null)) {
                possibleMatches.copyInto(result, index);
                index += possibleMatches.size();
            }
            ++i;
        }
        if (index < this.elementCount) {
            Object[] objectArray = result;
            result = new PossibleMatch[index];
            System.arraycopy(objectArray, 0, result, 0, index);
        }
        return result;
    }

    public void reset() {
        this.rootsToPossibleMatches = new SimpleLookupTable(5);
        this.elementCount = 0;
    }
}

