/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourcePersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourcePersistentAttributeImpl
extends AbstractJavaResourcePersistentMember<Attribute>
implements JavaResourcePersistentAttribute {
    private boolean typeIsBasic;
    private String qualifiedTypeName;
    private boolean typeIsContainer;
    private String qualifiedReferenceEntityTypeName;
    private String qualifiedReferenceEntityElementTypeName;
    private boolean public_;
    private boolean final_;
    private static final String MAP_TYPE_NAME = Map.class.getName();
    private static final String[] CONTAINER_TYPE_NAMES = new String[]{Collection.class.getName(), Set.class.getName(), List.class.getName(), MAP_TYPE_NAME};
    private static final String[] VALID_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES = new String[]{Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), Boolean.class.getName()};
    private static final String[] OTHER_SUPPORTED_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    private static final String SERIALIZABLE_TYPE_NAME = Serializable.class.getName();

    public static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, String name, int occurrence, JpaCompilationUnit jpaCompilationUnit, CompilationUnit astRoot) {
        JDTFieldAttribute attribute = new JDTFieldAttribute(declaringType, name, occurrence, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentAttributeImpl field = new JavaResourcePersistentAttributeImpl(parent, attribute);
        field.initialize(astRoot);
        return field;
    }

    public static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, MethodSignature signature, int occurrence, JpaCompilationUnit jpaCompilationUnit, CompilationUnit astRoot) {
        JDTMethodAttribute attribute = JDTMethodAttribute.newInstance(declaringType, signature, occurrence, jpaCompilationUnit.getCompilationUnit(), jpaCompilationUnit.getModifySharedDocumentCommandExecutorProvider(), jpaCompilationUnit.getAnnotationEditFormatter());
        JavaResourcePersistentAttributeImpl field = new JavaResourcePersistentAttributeImpl(parent, attribute);
        field.initialize(astRoot);
        return field;
    }

    public JavaResourcePersistentAttributeImpl(JavaResourcePersistentType parent, Attribute attribute) {
        super(parent, attribute);
    }

    @Override
    public String getName() {
        return ((Attribute)this.getMember()).getAttributeName();
    }

    @Override
    protected Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildAttributeMappingAnnotation(this, (Attribute)this.getMember(), mappingAnnotationName);
    }

    @Override
    protected Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildAttributeAnnotation(this, (Attribute)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeAnnotation(this, (Attribute)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeMappingAnnotation(this, (Attribute)this.getMember(), annotationName);
    }

    @Override
    protected ListIterator<String> possibleMappingAnnotationNames() {
        return this.getAnnotationProvider().attributeMappingAnnotationNames();
    }

    @Override
    protected boolean isPossibleAnnotation(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().attributeAnnotationNames(), (Object)annotationName);
    }

    @Override
    protected boolean isPossibleMappingAnnotation(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().attributeMappingAnnotationNames(), (Object)annotationName);
    }

    @Override
    public ListIterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        return super.annotations(nestableAnnotationName, containerAnnotationName);
    }

    @Override
    public Iterator<Annotation> mappingAnnotations() {
        return super.mappingAnnotations();
    }

    @Override
    public Iterator<Annotation> annotations() {
        return super.annotations();
    }

    @Override
    public boolean isFor(MethodSignature signature, int occurrence) {
        return ((MethodAttribute)this.getMember()).matches(signature, occurrence);
    }

    @Override
    public boolean isForField() {
        return ((Attribute)this.getMember()).isField();
    }

    @Override
    public boolean isForProperty() {
        return !this.isForField();
    }

    @Override
    public boolean hasAnyAnnotation() {
        if (this.mappingAnnotationsSize() > 0) {
            return true;
        }
        return this.annotationsSize() > 0;
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    protected void setPublic(boolean newPublic) {
        boolean oldPublic = this.public_;
        this.public_ = newPublic;
        this.firePropertyChanged("publicProperty", oldPublic, newPublic);
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    protected void setFinal(boolean newFinal) {
        boolean oldFinal = this.final_;
        this.final_ = newFinal;
        this.firePropertyChanged("finalProperty", oldFinal, newFinal);
    }

    @Override
    public boolean typeIsBasic() {
        return this.typeIsBasic;
    }

    protected void setTypeIsBasic(boolean newTypeIsBasic) {
        boolean oldTypeIsBasic = this.typeIsBasic;
        this.typeIsBasic = newTypeIsBasic;
        this.firePropertyChanged("typeIsBasicProperty", oldTypeIsBasic, newTypeIsBasic);
    }

    @Override
    public String getQualifiedTypeName() {
        return this.qualifiedTypeName;
    }

    protected void setQualifiedTypeName(String newQualifiedTypeName) {
        String oldQualifiedTypeName = this.qualifiedTypeName;
        this.qualifiedTypeName = newQualifiedTypeName;
        this.firePropertyChanged("qualfiedTypeNameProperty", oldQualifiedTypeName, newQualifiedTypeName);
    }

    @Override
    public String getQualifiedReferenceEntityTypeName() {
        return this.qualifiedReferenceEntityTypeName;
    }

    protected void setQualifiedReferenceEntityTypeName(String newQualifiedReferenceEntityTypeName) {
        String oldQualifiedReferenceEntityTypeName = this.qualifiedReferenceEntityTypeName;
        this.qualifiedReferenceEntityTypeName = newQualifiedReferenceEntityTypeName;
        this.firePropertyChanged("qualfiedReferenceEntityTypeNameProperty", oldQualifiedReferenceEntityTypeName, newQualifiedReferenceEntityTypeName);
    }

    @Override
    public String getQualifiedReferenceEntityElementTypeName() {
        return this.qualifiedReferenceEntityElementTypeName;
    }

    protected void setQualifiedReferenceEntityElementTypeName(String newQualifiedReferenceEntityElementTypeName) {
        String oldQualifiedReferenceEntityElementTypeName = this.qualifiedReferenceEntityElementTypeName;
        this.qualifiedReferenceEntityElementTypeName = newQualifiedReferenceEntityElementTypeName;
        this.firePropertyChanged("qualfiedReferenceEntityElementTypeNameProperty", oldQualifiedReferenceEntityElementTypeName, newQualifiedReferenceEntityElementTypeName);
    }

    @Override
    public boolean typeIsContainer() {
        return this.typeIsContainer;
    }

    protected void setTypeIsContainer(boolean newTypeIsContainer) {
        boolean oldTypeIsContainer = this.typeIsContainer;
        this.typeIsContainer = newTypeIsContainer;
        this.firePropertyChanged("typeIsContainerProperty", oldTypeIsContainer, newTypeIsContainer);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.typeIsBasic = this.typeIsBasic(astRoot);
        this.qualifiedTypeName = this.qualifiedTypeName(astRoot);
        this.qualifiedReferenceEntityTypeName = this.qualifiedReferenceEntityTypeName(astRoot);
        this.qualifiedReferenceEntityElementTypeName = this.qualifiedReferenceEntityElementTypeName(astRoot);
        this.typeIsContainer = this.typeIsContainer(astRoot);
        this.final_ = this.isFinal(astRoot);
        this.public_ = this.isPublic(astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setTypeIsBasic(this.typeIsBasic(astRoot));
        this.setQualifiedTypeName(this.qualifiedTypeName(astRoot));
        this.setQualifiedReferenceEntityTypeName(this.qualifiedReferenceEntityTypeName(astRoot));
        this.setQualifiedReferenceEntityElementTypeName(this.qualifiedReferenceEntityElementTypeName(astRoot));
        this.setTypeIsContainer(this.typeIsContainer(astRoot));
        this.setFinal(this.isFinal(astRoot));
        this.setPublic(this.isPublic(astRoot));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setTypeIsBasic(this.typeIsBasic(astRoot));
        this.setQualifiedTypeName(this.qualifiedTypeName(astRoot));
        this.setQualifiedReferenceEntityTypeName(this.qualifiedReferenceEntityTypeName(astRoot));
        this.setQualifiedReferenceEntityElementTypeName(this.qualifiedReferenceEntityElementTypeName(astRoot));
        this.setTypeIsContainer(this.typeIsContainer(astRoot));
    }

    protected boolean typeIsBasic(CompilationUnit astRoot) {
        return JavaResourcePersistentAttributeImpl.typeIsBasic(((Attribute)this.getMember()).getTypeBinding(astRoot), astRoot.getAST());
    }

    protected boolean isFinal(CompilationUnit astRoot) {
        IBinding binding = ((Attribute)this.getMember()).getBinding(astRoot);
        return binding == null ? false : Modifier.isFinal((int)binding.getModifiers());
    }

    protected boolean isPublic(CompilationUnit astRoot) {
        IBinding binding = ((Attribute)this.getMember()).getBinding(astRoot);
        return binding == null ? false : Modifier.isPublic((int)binding.getModifiers());
    }

    protected String qualifiedReferenceEntityTypeName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Attribute)this.getMember()).getTypeBinding(astRoot);
        return typeBinding == null ? null : JavaResourcePersistentAttributeImpl.buildReferenceEntityTypeName(typeBinding);
    }

    public static String buildReferenceEntityTypeName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isArray()) {
            return null;
        }
        return typeBinding.getTypeDeclaration().getQualifiedName();
    }

    protected String qualifiedReferenceEntityElementTypeName(CompilationUnit astRoot) {
        ITypeBinding elementTypeBinding;
        ITypeBinding typeBinding = ((Attribute)this.getMember()).getTypeBinding(astRoot);
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length == 1) {
            elementTypeBinding = typeArguments[0];
        } else if (typeArguments.length == 2 && JavaResourcePersistentAttributeImpl.typeNamedIsMap(this.qualifiedTypeName(astRoot))) {
            elementTypeBinding = typeArguments[1];
        } else {
            return null;
        }
        String elementTypeName = JavaResourcePersistentAttributeImpl.buildReferenceEntityTypeName(elementTypeBinding);
        return JavaResourcePersistentAttributeImpl.typeNamedIsContainer(elementTypeName) ? null : elementTypeName;
    }

    protected boolean typeIsContainer(CompilationUnit astRoot) {
        String typeName = JavaResourcePersistentAttributeImpl.buildReferenceEntityTypeName(((Attribute)this.getMember()).getTypeBinding(astRoot));
        return typeName == null ? false : JavaResourcePersistentAttributeImpl.typeNamedIsContainer(typeName);
    }

    public static boolean typeNamedIsMap(String typeName) {
        return MAP_TYPE_NAME.equals(typeName);
    }

    public static boolean typeNamedIsContainer(String typeName) {
        return CollectionTools.contains((Object[])CONTAINER_TYPE_NAMES, (Object)typeName);
    }

    protected String qualifiedTypeName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Attribute)this.getMember()).getTypeBinding(astRoot);
        return typeBinding == null ? null : typeBinding.getTypeDeclaration().getQualifiedName();
    }

    public static boolean typeIsBasic(ITypeBinding typeBinding, AST ast) {
        if (typeBinding == null) {
            return false;
        }
        if (typeBinding.isPrimitive()) {
            return true;
        }
        if (typeBinding.isArray()) {
            if (typeBinding.getDimensions() > 1) {
                return false;
            }
            ITypeBinding elementTypeBinding = typeBinding.getElementType();
            if (elementTypeBinding == null) {
                return false;
            }
            return JavaResourcePersistentAttributeImpl.elementTypeIsValid(elementTypeBinding.getQualifiedName());
        }
        String typeName = typeBinding.getQualifiedName();
        if (JavaResourcePersistentAttributeImpl.typeIsPrimitiveWrapper(typeName)) {
            return true;
        }
        if (JavaResourcePersistentAttributeImpl.typeIsOtherSupportedType(typeName)) {
            return true;
        }
        if (typeBinding.isEnum()) {
            return true;
        }
        return JavaResourcePersistentAttributeImpl.typeImplementsSerializable(typeBinding, ast);
    }

    private static boolean elementTypeIsValid(String elementTypeName) {
        return CollectionTools.contains((Object[])VALID_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    private static boolean typeIsPrimitiveWrapper(String typeName) {
        return CollectionTools.contains((Object[])PRIMITIVE_WRAPPER_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeIsOtherSupportedType(String typeName) {
        return CollectionTools.contains((Object[])OTHER_SUPPORTED_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeImplementsSerializable(ITypeBinding typeBinding, AST ast) {
        ITypeBinding serializableTypeBinding = ast.resolveWellKnownType(SERIALIZABLE_TYPE_NAME);
        return typeBinding.isAssignmentCompatible(serializableTypeBinding);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

