/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NullList;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCollectionValueModel<E1, E2>
extends CollectionValueModelWrapper<E1>
implements CollectionValueModel<E2> {
    private final Transformer<E1, CollectionValueModel<E2>> transformer;
    private final IdentityHashMap<E1, CollectionValueModel<E2>> componentCVMs;
    private final IdentityHashMap<CollectionValueModel<E2>, ArrayList<E2>> collections;
    private final CollectionChangeListener componentCVMListener;
    private int size;

    public CompositeCollectionValueModel(CollectionValueModel<? extends E1> collectionHolder) {
        this(collectionHolder, Transformer.Null.instance());
    }

    public CompositeCollectionValueModel(CollectionValueModel<? extends E1> collectionHolder, Transformer<E1, CollectionValueModel<E2>> transformer) {
        super(collectionHolder);
        this.transformer = transformer;
        this.componentCVMs = new IdentityHashMap();
        this.collections = new IdentityHashMap();
        this.componentCVMListener = this.buildComponentListener();
        this.size = 0;
    }

    public CompositeCollectionValueModel(ListValueModel<? extends E1> listHolder) {
        this((CollectionValueModel<? extends E1>)new ListCollectionValueModelAdapter<E1>(listHolder));
    }

    public CompositeCollectionValueModel(ListValueModel<? extends E1> listHolder, Transformer<E1, CollectionValueModel<E2>> transformer) {
        this(new ListCollectionValueModelAdapter<E1>(listHolder), transformer);
    }

    public CompositeCollectionValueModel(Collection<? extends E1> collection) {
        this((CollectionValueModel<? extends E1>)new StaticCollectionValueModel<E1>(collection));
    }

    public CompositeCollectionValueModel(Collection<? extends E1> collection, Transformer<E1, CollectionValueModel<E2>> transformer) {
        this(new StaticCollectionValueModel<E1>(collection), transformer);
    }

    protected CollectionChangeListener buildComponentListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                CompositeCollectionValueModel.this.componentItemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                CompositeCollectionValueModel.this.componentItemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                CompositeCollectionValueModel.this.componentCollectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CompositeCollectionValueModel.this.componentCollectionChanged(event);
            }

            public String toString() {
                return "component listener";
            }
        };
    }

    @Override
    public Iterator<E2> iterator() {
        return new CompositeIterator<E2>(this.buildCollectionsIterators());
    }

    protected Iterator<Iterator<E2>> buildCollectionsIterators() {
        return new TransformationIterator<ArrayList<E2>, Iterator<E2>>(this.collections.values().iterator()){

            @Override
            protected Iterator<E2> transform(ArrayList<E2> next) {
                return next.iterator();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.addAllComponentSources();
    }

    protected void addAllComponentSources() {
        for (Object source : this.collectionHolder) {
            this.addComponentSource(source, NullList.instance());
        }
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        for (CollectionValueModel<E2> componentCVM : this.componentCVMs.values()) {
            componentCVM.removeCollectionChangeListener("values", this.componentCVMListener);
        }
        this.componentCVMs.clear();
        this.collections.clear();
        this.size = 0;
    }

    @Override
    protected void itemsAdded(CollectionChangeEvent event) {
        ArrayList addedItems = new ArrayList();
        Iterator stream = this.items(event);
        while (stream.hasNext()) {
            this.addComponentSource(stream.next(), addedItems);
        }
        this.fireItemsAdded("values", addedItems);
    }

    protected void addComponentSource(E1 source, List<E2> addedItems) {
        CollectionValueModel<E2> componentCVM = this.transform(source);
        if (this.componentCVMs.put(source, componentCVM) != null) {
            throw new IllegalStateException("duplicate component: " + source);
        }
        componentCVM.addCollectionChangeListener("values", this.componentCVMListener);
        ArrayList componentCollection = new ArrayList(componentCVM.size());
        if (this.collections.put(componentCVM, componentCollection) != null) {
            throw new IllegalStateException("duplicate collection: " + source);
        }
        this.addComponentItems(componentCVM, componentCollection);
        addedItems.addAll(componentCollection);
    }

    protected void addComponentItems(CollectionValueModel<E2> componentCVM, ArrayList<E2> componentCollection) {
        int itemsSize = componentCVM.size();
        this.size += itemsSize;
        componentCollection.ensureCapacity(componentCollection.size() + itemsSize);
        CollectionTools.addAll(componentCollection, componentCVM);
    }

    @Override
    protected void itemsRemoved(CollectionChangeEvent event) {
        ArrayList removedItems = new ArrayList();
        Iterator stream = this.items(event);
        while (stream.hasNext()) {
            this.removeComponentSource(stream.next(), removedItems);
        }
        this.fireItemsRemoved("values", removedItems);
    }

    protected void removeComponentSource(E1 source, List<E2> removedItems) {
        CollectionValueModel<E2> componentCVM = this.componentCVMs.remove(source);
        if (componentCVM == null) {
            throw new IllegalStateException("missing component: " + source);
        }
        componentCVM.removeCollectionChangeListener("values", this.componentCVMListener);
        ArrayList<E2> componentCollection = this.collections.remove(componentCVM);
        if (componentCollection == null) {
            throw new IllegalStateException("missing collection: " + source);
        }
        removedItems.addAll(componentCollection);
        this.removeComponentItems(componentCollection);
    }

    protected void removeComponentItems(ArrayList<E2> componentCollection) {
        this.size -= componentCollection.size();
        componentCollection.clear();
    }

    @Override
    protected void collectionCleared(CollectionChangeEvent event) {
        this.removeAllComponentSources();
        this.fireCollectionCleared("values");
    }

    protected void removeAllComponentSources() {
        ArrayList copy = new ArrayList(this.componentCVMs.keySet());
        for (Object source : copy) {
            this.removeComponentSource(source, NullList.instance());
        }
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.removeAllComponentSources();
        this.addAllComponentSources();
        this.fireCollectionChanged("values");
    }

    protected CollectionValueModel<E2> transform(E1 value) {
        return this.transformer.transform(value);
    }

    protected void componentItemsAdded(CollectionChangeEvent event) {
        int itemsSize = event.itemsSize();
        this.size += itemsSize;
        ArrayList<E2> componentCollection = this.collections.get(this.componentCVM(event));
        componentCollection.ensureCapacity(componentCollection.size() + itemsSize);
        this.addItemsToCollection(this.componentItems(event), componentCollection, "values");
    }

    protected void componentItemsRemoved(CollectionChangeEvent event) {
        this.size -= event.itemsSize();
        ArrayList<E2> componentCollection = this.collections.get(this.componentCVM(event));
        this.removeItemsFromCollection(this.componentItems(event), componentCollection, "values");
    }

    protected void componentCollectionCleared(CollectionChangeEvent event) {
        ArrayList<E2> componentCollection = this.collections.get(this.componentCVM(event));
        ArrayList<E2> removedItems = new ArrayList<E2>(componentCollection);
        this.removeComponentItems(componentCollection);
        this.fireItemsRemoved("values", removedItems);
    }

    protected void componentCollectionChanged(CollectionChangeEvent event) {
        CollectionValueModel<E2> componentCVM = this.componentCVM(event);
        ArrayList<E2> componentCollection = this.collections.get(componentCVM);
        this.removeComponentItems(componentCollection);
        this.addComponentItems(componentCVM, componentCollection);
        this.fireCollectionChanged("values");
    }

    protected Iterator<E2> componentItems(CollectionChangeEvent event) {
        return event.items();
    }

    protected CollectionValueModel<E2> componentCVM(CollectionChangeEvent event) {
        return (CollectionValueModel)event.getSource();
    }
}

