/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryUpgradeUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.UpgradeStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class RegistryUpgradeCommitHandler {
    public static void commitMigrationIfNecessary() {
        JSFLibraryRegistryUpgradeUtil upgradeUtil = JSFLibraryRegistryUpgradeUtil.getInstance();
        UpgradeStatus status = upgradeUtil.getUpgradeStatus();
        if (status.getSeverity() == 0) {
            if (status.isUpgradeOccurred()) {
                RegistryUpgradeCommitHandler.handle05_to_10(status);
            }
        } else {
            RegistryUpgradeCommitHandler.handleErrorInMigration(status);
        }
    }

    private static void handle05_to_10(UpgradeStatus status) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new Handle05_to_10_migration(status));
    }

    private static void handleErrorInMigration(UpgradeStatus status) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Serious Error Encountered!", (String)"An unrecoverable error occurred while trying to migrate your JSF Library Registry to a newer version.  This may cause your library references to be broken in your JSF projects.");
            }
        });
    }

    private static class Handle05_to_10_migration
    implements Runnable {
        private final UpgradeStatus _status;

        Handle05_to_10_migration(UpgradeStatus status) {
            this._status = status;
        }

        public void run() {
            this.doConfirmed(false);
        }

        private void doConfirmed(boolean userWantsMigrationDocLaunch) {
            IStatus result = this._status.commit();
            if (result.getSeverity() != 0) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)Messages.RegistryMigrationStartupHandler_Error_committing_migration, (String)result.getMessage());
            }
            if (userWantsMigrationDocLaunch) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    URL url = new URL("http://wiki.eclipse.org/index.php/JSF_Library_Migration");
                    browserSupport.createBrowser("JSFMigrationDoc").openURL(url);
                }
                catch (PartInitException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "Error handling migration");
                }
                catch (MalformedURLException e) {
                    JSFCorePlugin.log(e, "Error handling migration");
                }
            }
        }
    }
}

