/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.style;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForCSS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class LineStyleProviderForEmbeddedCSS
extends LineStyleProviderForCSS {
    int fCacheKey = -1;
    ParserCache fCacheResult = null;

    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        List tokens;
        int offset;
        int regionStart = typedRegion.getOffset();
        int regionEnd = regionStart + typedRegion.getLength();
        IStructuredDocumentRegion wholeRegion = this.getDocument().getRegionAtCharacterOffset(regionStart);
        ParserCache cache = this.getCachedParsingResult(wholeRegion);
        if (cache == null) {
            offset = wholeRegion.getStartOffset();
            String content = wholeRegion.getText();
            CSSTextParser parser = new CSSTextParser(0, content);
            tokens = parser.getTokenList();
            this.cacheParsingResult(wholeRegion, new ParserCache(offset, tokens));
        } else {
            tokens = cache.tokens;
            offset = cache.offset;
        }
        boolean result = false;
        if (tokens.size() > 0) {
            int start;
            int end = start = offset;
            Iterator i = tokens.iterator();
            while (i.hasNext()) {
                CSSTextToken token = (CSSTextToken)i.next();
                end = start + token.length;
                int styleLength = token.length;
                if (regionStart <= start && start < regionEnd) {
                    if (regionEnd < end) {
                        styleLength = regionEnd - start;
                    }
                    this.addStyleRange(holdResults, this.getAttributeFor(token.kind), start, styleLength);
                } else if (start <= regionStart && regionStart < end) {
                    if (end < regionEnd) {
                        styleLength = end - regionStart;
                    }
                    this.addStyleRange(holdResults, this.getAttributeFor(token.kind), regionStart, styleLength);
                }
                start += token.length;
            }
            result = true;
        }
        return result;
    }

    private void addStyleRange(Collection holdResults, TextAttribute attribute, int start, int end) {
        if (attribute != null) {
            holdResults.add(new StyleRange(start, end, attribute.getForeground(), attribute.getBackground(), attribute.getStyle()));
        } else {
            holdResults.add(new StyleRange(start, end, null, null));
        }
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        return null;
    }

    private void cleanupCache() {
        this.fCacheKey = -1;
        this.fCacheResult = null;
    }

    private ParserCache getCachedParsingResult(IStructuredDocumentRegion region) {
        if (this.fCacheKey == region.getText().hashCode()) {
            return this.fCacheResult;
        }
        return null;
    }

    private void cacheParsingResult(IStructuredDocumentRegion region, ParserCache result) {
        this.fCacheKey = region.getText().hashCode();
        this.fCacheResult = result;
    }

    public void release() {
        super.release();
        this.cleanupCache();
    }

    private class ParserCache {
        int offset;
        List tokens;

        ParserCache(int newOffset, List newTokens) {
            this.offset = newOffset;
            this.tokens = newTokens;
        }
    }
}

