/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleTest
extends AbstractModelTest {
    public void testInsertRuleDoubleQuote() {
        this.checkInsert("@import \"dummy.css\";", "dummy.css", null);
    }

    public void testInsertRuleSingleQuote() {
        this.checkInsert("@import 'dummy.css';", "dummy.css", null);
    }

    public void testInsertRuleUrlNoQuote() {
        this.checkInsert("@import url(dummy.css);", "dummy.css", null);
    }

    public void testInsertRuleUrlDoubleQuote() {
        this.checkInsert("@import url(\"dummy.css\");", "dummy.css", null);
    }

    public void testInsertRuleUrlSingleQuote() {
        this.checkInsert("@import url('dummy.css');", "dummy.css", null);
    }

    public void testInsertRuleMedia1() {
        this.checkInsert("@import url(\"dummy.css\") media1;", "dummy.css", new String[]{"media1"});
    }

    public void testInsertRuleMedia2() {
        this.checkInsert("@import url('dummy.css') media1, media2;", "dummy.css", new String[]{"media1", "media2"});
    }

    public void testCreateRule() {
        ICSSStyleSheet sheet;
        ICSSStyleSheet doc = sheet = this.getStyleSheet();
        ICSSImportRule newRule = doc.createCSSImportRule();
        newRule.setHref("dummy.css");
        MediaList newList = newRule.getMedia();
        newList.appendMedium("media1");
        newList.appendMedium("media2");
        sheet.insertRuleBefore((CSSRule)newRule, null);
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSImportRuleTest.assertTrue((boolean)(rule instanceof CSSImportRule));
        CSSImportRule importRule = (CSSImportRule)rule;
        CSSImportRuleTest.assertEquals((String)"dummy.css", (String)importRule.getHref());
        MediaList mediaList = importRule.getMedia();
        CSSImportRuleTest.assertEquals((int)2, (int)mediaList.getLength());
        CSSImportRuleTest.assertEquals((String)"media1", (String)mediaList.item(0));
        CSSImportRuleTest.assertEquals((String)"media2", (String)mediaList.item(1));
        CSSImportRuleTest.assertEquals((String)"@import url(\"dummy.css\") media1, media2;", (String)importRule.getCssText());
    }

    private void checkInsert(String ruleString, String href, String[] media) {
        ICSSStyleSheet sheet = this.getStyleSheet();
        CSSImportRuleTest.assertEquals((int)0, (int)sheet.insertRule(ruleString, 0));
        CSSRuleList ruleList = sheet.getCssRules();
        CSSRule rule = ruleList.item(0);
        CSSImportRuleTest.assertTrue((boolean)(rule instanceof CSSImportRule));
        CSSImportRule importRule = (CSSImportRule)rule;
        CSSImportRuleTest.assertEquals((String)href, (String)importRule.getHref());
        if (media != null) {
            CSSImportRuleTest.assertEquals((int)media.length, (int)importRule.getMedia().getLength());
            int i = 0;
            while (i < media.length) {
                CSSImportRuleTest.assertEquals((String)media[i], (String)importRule.getMedia().item(i));
                ++i;
            }
        }
        CSSImportRuleTest.assertEquals((String)ruleString, (String)importRule.getCssText());
    }
}

