/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.AbstractTests;
import org.eclipse.wst.common.project.facet.core.tests.support.TestUtils;

public final class ProjectCreationTests
extends AbstractTests {
    private static final String FACETED_PROJECT_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static IProjectFacet f1 = ProjectFacetsManager.getProjectFacet((String)"pct-f1");
    private static IProjectFacetVersion f1v1 = f1.getVersion("1.0");
    private static IProjectFacet f2 = ProjectFacetsManager.getProjectFacet((String)"pct-f2");
    private static IProjectFacetVersion f2v1 = f2.getVersion("1.0");

    private ProjectCreationTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project Creation Tests");
        suite.addTest((Test)new ProjectCreationTests("testCreationFromScratch1"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromScratch2"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromScratch3"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromScratch4"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromNonFacetedProject1"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromNonFacetedProject2"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromNonFacetedProject3"));
        suite.addTest((Test)new ProjectCreationTests("testCreationFromNonFacetedProject4"));
        suite.addTest((Test)new ProjectCreationTests("testWrapperCreation1"));
        suite.addTest((Test)new ProjectCreationTests("testWrapperCreation2"));
        suite.addTest((Test)new ProjectCreationTests("testWrapperCreation3"));
        return suite;
    }

    public void testCreationFromScratch1() throws CoreException, IOException {
        IFacetedProject fproj = ProjectFacetsManager.create((String)"abc", null, null);
        IProject proj = fproj.getProject();
        ProjectCreationTests.assertNotNull((Object)proj);
        ProjectCreationTests.assertTrue((boolean)proj.exists());
        this.resourcesToCleanup.add(proj);
        TestUtils.assertFileContains(proj.getFile(".project"), FACETED_PROJECT_NATURE);
        ProjectCreationTests.assertEquals((int)fproj.getFixedProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getTargetedRuntimes().size(), (int)0);
        ProjectCreationTests.assertNull((Object)fproj.getPrimaryRuntime());
    }

    public void testCreationFromScratch2() throws CoreException, IOException {
        IFacetedProject fproj = ProjectFacetsManager.create((String)"abc", null, null);
        this.resourcesToCleanup.add(fproj.getProject());
        try {
            ProjectFacetsManager.create((String)"abc", null, null);
            ProjectCreationTests.fail();
        }
        catch (CoreException coreException) {}
    }

    public void testCreationFromScratch3() throws CoreException, IOException {
        IProject project = ws.getRoot().getProject("abc");
        IProjectDescription desc = ws.newProjectDescription("abc");
        desc.setLocation(null);
        project.create(desc, null);
        project.open(null);
        this.resourcesToCleanup.add(project);
        try {
            ProjectFacetsManager.create((String)"abc", null, null);
            ProjectCreationTests.fail();
        }
        catch (CoreException coreException) {}
    }

    public void testCreationFromScratch4() throws CoreException, IOException {
        IFacetedProject fproj = ProjectFacetsManager.create((String)"abc", null, null);
        this.resourcesToCleanup.add(fproj.getProject());
        fproj.installProjectFacet(f1v1, null, null);
        fproj.installProjectFacet(f2v1, null, null);
        fproj.getProject().delete(false, false, null);
        fproj = ProjectFacetsManager.create((String)"abc", null, null);
        ProjectCreationTests.assertEquals((int)fproj.getFixedProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getProjectFacets().size(), (int)2);
        ProjectCreationTests.assertTrue((boolean)fproj.hasProjectFacet(f1v1));
        ProjectCreationTests.assertTrue((boolean)fproj.hasProjectFacet(f2v1));
        ProjectCreationTests.assertEquals((int)fproj.getTargetedRuntimes().size(), (int)0);
        ProjectCreationTests.assertNull((Object)fproj.getPrimaryRuntime());
    }

    public void testCreationFromNonFacetedProject1() throws CoreException, IOException {
        IProject project = ws.getRoot().getProject("abc");
        IProjectDescription desc = ws.newProjectDescription("abc");
        desc.setLocation(null);
        project.create(desc, null);
        project.open(null);
        this.resourcesToCleanup.add(project);
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project, (boolean)true, null);
        ProjectCreationTests.assertEquals((int)fproj.getFixedProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getTargetedRuntimes().size(), (int)0);
        ProjectCreationTests.assertNull((Object)fproj.getPrimaryRuntime());
    }

    public void testCreationFromNonFacetedProject2() throws CoreException, IOException {
        IFacetedProject prior = ProjectFacetsManager.create((String)"abc", null, null);
        IProject project = prior.getProject();
        this.resourcesToCleanup.add(project);
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project, (boolean)true, null);
        ProjectCreationTests.assertEquals((int)fproj.getFixedProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getTargetedRuntimes().size(), (int)0);
        ProjectCreationTests.assertNull((Object)fproj.getPrimaryRuntime());
    }

    public void testCreationFromNonFacetedProject3() throws CoreException, IOException {
        IFacetedProject prior = ProjectFacetsManager.create((String)"abc", null, null);
        IProject project = prior.getProject();
        this.resourcesToCleanup.add(project);
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project, (boolean)false, null);
        ProjectCreationTests.assertEquals((int)fproj.getFixedProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getProjectFacets().size(), (int)0);
        ProjectCreationTests.assertEquals((int)fproj.getTargetedRuntimes().size(), (int)0);
        ProjectCreationTests.assertNull((Object)fproj.getPrimaryRuntime());
    }

    public void testCreationFromNonFacetedProject4() throws CoreException, IOException {
        IProject project = ws.getRoot().getProject("abc");
        IProjectDescription desc = ws.newProjectDescription("abc");
        desc.setLocation(null);
        project.create(desc, null);
        project.open(null);
        this.resourcesToCleanup.add(project);
        ProjectCreationTests.assertNull((Object)ProjectFacetsManager.create((IProject)project, (boolean)false, null));
    }

    public void testWrapperCreation1() throws CoreException {
        IFacetedProject fproj = ProjectFacetsManager.create((String)"abc", null, null);
        IProject proj = fproj.getProject();
        this.resourcesToCleanup.add(proj);
        ProjectCreationTests.assertTrue((fproj == ProjectFacetsManager.create((IProject)proj) ? 1 : 0) != 0);
        ProjectCreationTests.assertTrue((fproj == ProjectFacetsManager.create((IProject)proj) ? 1 : 0) != 0);
        ProjectCreationTests.assertTrue((fproj == ProjectFacetsManager.create((IProject)proj) ? 1 : 0) != 0);
        ProjectCreationTests.assertTrue((fproj == ProjectFacetsManager.create((IProject)proj) ? 1 : 0) != 0);
        ProjectCreationTests.assertTrue((fproj == ProjectFacetsManager.create((IProject)proj) ? 1 : 0) != 0);
    }

    public void testWrapperCreation2() throws CoreException {
        IProject proj = ws.getRoot().getProject("abc");
        ProjectCreationTests.assertNull((Object)ProjectFacetsManager.create((IProject)proj));
    }

    public void testWrapperCreation3() throws CoreException {
        IFacetedProject fproj = ProjectFacetsManager.create((String)"abc", null, null);
        IProject proj = fproj.getProject();
        this.resourcesToCleanup.add(proj);
        proj.close(null);
        ProjectCreationTests.assertNull((Object)ProjectFacetsManager.create((IProject)proj));
    }
}

