/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.extensions;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPFault;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.binding.soap.SOAPPackage;
import org.eclipse.wst.wsdl.binding.soap.internal.generator.SOAPContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.extension.ContentGeneratorExtensionFactoryRegistry;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.extensions.WSDLExtensionsTest;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPExtensionsTest
extends WSDLExtensionsTest {
    private static final String HTTP_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    private static final String LOCATION_URI = "http://www.example.org/";
    private static final String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private static final String SOAP_ACTION_URI = "http://www.example.org/SOAPTest/NewOperation";
    private static final SOAPFactory SOAP_FACTORY = SOAPFactory.eINSTANCE;
    private static final String STYLE_DOCUMENT = "document";
    private static final String STYLE_RPC = "rpc";
    private static final String USE_LITERAL = "literal";
    private static final String USE_ENCODED = "encoded";

    public static void main(String[] args) {
        TestRunner.run((Test)SOAPExtensionsTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new SOAPExtensionsTest("SOAPExtensionsCreation"){

            protected void runTest() {
                this.testSOAPExtensionsCreation();
            }
        });
        suite.addTest((Test)new SOAPExtensionsTest("EMFSerialization"){

            protected void runTest() {
                this.testEMFSerialization();
            }
        });
        suite.addTest((Test)new SOAPExtensionsTest("SOAPExtensionsReconciliation"){

            protected void runTest() {
                this.testSOAPExtensionsReconciliation();
            }
        });
        suite.addTest((Test)new SOAPExtensionsTest("SOAPContentGenerator"){

            protected void runTest() {
                this.testSOAPContentGenerator();
            }
        });
        return suite;
    }

    public SOAPExtensionsTest(String name) {
        super(name);
    }

    public void testSOAPExtensionsCreation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/SOAP/SOAPTest.wsdl");
            String bindingName = "SOAPTestSOAP";
            String targetNamespace = "http://www.example.org/SOAPTest/";
            QName bindingQName = new QName(targetNamespace, bindingName);
            Binding binding = (Binding)definition.getBinding(bindingQName);
            this.addSOAPBinding(binding);
            BindingOperation bindingOperation = (BindingOperation)binding.getBindingOperation("NewOperation", null, null);
            this.addSOAPOperation(bindingOperation);
            BindingInput bindingInput = bindingOperation.getEBindingInput();
            this.addSOAPBindingInput(bindingInput);
            BindingOutput bindingOutput = bindingOperation.getEBindingOutput();
            this.addSOAPBindingOutput(bindingOutput);
            String faultName = "fault";
            BindingFault bindingFault = (BindingFault)bindingOperation.getBindingFault(faultName);
            this.addSOAPBindingFault(bindingFault);
            this.addSOAPAddress(definition);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testSOAPContentGenerator() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/SOAP/SOAPTest.wsdl");
            SOAPContentGenerator contentGenerator = (SOAPContentGenerator)ContentGeneratorExtensionFactoryRegistry.getInstance().getGeneratorClassFromName("SOAP");
            String locationURI = "http://test.org/example";
            contentGenerator.setAddressLocation(locationURI);
            contentGenerator.setStyle(1);
            String serviceName = "SOAPTest";
            String targetNamespace = "http://www.example.org/SOAPTest/";
            QName serviceQName = new QName(targetNamespace, serviceName);
            Service service = (Service)definition.getService(serviceQName);
            Port port = (Port)service.getPort("SOAPTestSOAP");
            List extensibilityElements = port.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)0, (int)extensibilityElements.size());
            contentGenerator.generatePortContent(port);
            extensibilityElements = port.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElements.get(0);
            SOAPExtensionsTest.assertTrue((boolean)(extensibilityElement instanceof SOAPAddress));
            SOAPAddress soapAddress = (SOAPAddress)extensibilityElement;
            SOAPExtensionsTest.assertEquals((String)locationURI, (String)soapAddress.getLocationURI());
            QName bindingQName = new QName(targetNamespace, "SOAPTestSOAP");
            Binding binding = (Binding)definition.getBinding(bindingQName);
            QName portTypeQName = new QName(targetNamespace, "SOAPTest");
            PortType portType = (PortType)definition.getPortType(portTypeQName);
            contentGenerator.generateBindingContent(binding, portType);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testEMFSerialization() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/SOAP/DocumentLiteralSOAPExample.wsdl", true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/generated/DocumentLiteralSOAPExample.xml"));
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)definition);
            resource.save(null);
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.getResource(fileURI, false);
            definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/SOAP/RPCLiteralSOAPExample.wsdl", true);
            fileURI = URI.createFileURI((String)(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/generated/RPCLiteralSOAPExample.xml"));
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)definition);
            resource.save(null);
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.getResource(fileURI, true);
            definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/SOAP/RPCEncodedSOAPExample.wsdl", true);
            fileURI = URI.createFileURI((String)(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/generated/RPCEncodedSOAPExample.xml"));
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)definition);
            resource.save(null);
            resourceSet = new ResourceSetImpl();
            resource = resourceSet.getResource(fileURI, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testSOAPExtensionsReconciliation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(PLUGIN_ABSOLUTE_PATH) + "samples/Extensions/SOAP/DocumentLiteralSOAPExample.wsdl", true);
            String serviceName = "DocumentLiteralSOAPExample";
            String targetNamespace = "http://www.example.org/DocumentLiteralSOAPExample/";
            QName serviceQName = new QName(targetNamespace, serviceName);
            Service service = (Service)definition.getService(serviceQName);
            service.toString();
            Port port = (Port)service.getPort("DocumentLiteralSOAPExampleSOAP");
            List extensibilityElements = port.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            SOAPAddress soapAddress = (SOAPAddress)extensibilityElements.get(0);
            this.checkStringAttributeReconciliation((WSDLElement)soapAddress, "location", LOCATION_URI, (EStructuralFeature)SOAPPackage.Literals.SOAP_ADDRESS__LOCATION_URI);
            String bindingName = "DocumentLiteralSOAPExampleSOAP";
            QName bindingQName = new QName(targetNamespace, bindingName);
            Binding binding = (Binding)definition.getBinding(bindingQName);
            extensibilityElements = binding.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            SOAPBinding soapBinding = (SOAPBinding)extensibilityElements.get(0);
            String style = soapBinding.getStyle();
            SOAPExtensionsTest.assertEquals((String)STYLE_DOCUMENT, (String)style);
            this.checkStringAttributeReconciliation((WSDLElement)soapBinding, "style", STYLE_RPC, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING__STYLE);
            this.checkStringAttributeReconciliation((WSDLElement)soapBinding, "transport", HTTP_TRANSPORT_URI, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING__TRANSPORT_URI);
            BindingOperation bindingOperation = (BindingOperation)binding.getBindingOperation("NewOperation", null, null);
            extensibilityElements = bindingOperation.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            SOAPOperation soapOperation = (SOAPOperation)extensibilityElements.get(0);
            style = soapOperation.getStyle();
            SOAPExtensionsTest.assertEquals((String)STYLE_DOCUMENT, (String)style);
            this.checkStringAttributeReconciliation((WSDLElement)soapOperation, "style", STYLE_RPC, (EStructuralFeature)SOAPPackage.Literals.SOAP_OPERATION__STYLE);
            BindingInput bindingInput = (BindingInput)bindingOperation.getBindingInput();
            extensibilityElements = bindingInput.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)2, (int)extensibilityElements.size());
            SOAPBody soapBody = (SOAPBody)extensibilityElements.get(0);
            String use = soapBody.getUse();
            SOAPExtensionsTest.assertEquals((String)USE_LITERAL, (String)use);
            this.checkStringAttributeReconciliation((WSDLElement)soapBody, "use", USE_ENCODED, (EStructuralFeature)SOAPPackage.Literals.SOAP_BODY__USE);
            SOAPHeader soapHeader = (SOAPHeader)extensibilityElements.get(1);
            String part = soapHeader.getPart();
            SOAPExtensionsTest.assertEquals((String)"header", (String)part);
            this.checkStringAttributeReconciliation((WSDLElement)soapHeader, "part", "test", (EStructuralFeature)SOAPPackage.Literals.SOAP_HEADER_BASE__PART);
            QName inputMessageQName = new QName(targetNamespace, "NewOperationRequestMsg");
            Message inputMessage = (Message)definition.getMessage(inputMessageQName);
            SOAPExtensionsTest.assertNotNull((Object)inputMessage);
            QName soapHeaderMessageQName = soapHeader.getMessage();
            SOAPExtensionsTest.assertEquals((Object)inputMessageQName, (Object)soapHeaderMessageQName);
            Element soapHeaderElement = soapHeader.getElement();
            Attr messageAttribute = soapHeaderElement.getAttributeNode("message");
            QName testMessageQName = new QName(targetNamespace, "TestMsg");
            Message testMessage = (Message)definition.getMessage(testMessageQName);
            messageAttribute.setValue("tns:TestMsg");
            SOAPExtensionsTest.assertEquals((Object)testMessage, (Object)soapHeader.getEMessage());
            QName message = soapHeader.getMessage();
            SOAPExtensionsTest.assertEquals((Object)testMessageQName, (Object)message);
            soapHeader.setMessage(null);
            messageAttribute = soapHeaderElement.getAttributeNode("message");
            SOAPExtensionsTest.assertNull((Object)messageAttribute);
            List soapHeaderFaults = soapHeader.getSOAPHeaderFaults();
            SOAPExtensionsTest.assertEquals((int)1, (int)soapHeaderFaults.size());
            soapHeaderFaults.clear();
            NodeList headerFaultNodes = soapHeaderElement.getElementsByTagName("headerfault");
            SOAPExtensionsTest.assertEquals((int)0, (int)headerFaultNodes.getLength());
            Document document = soapHeaderElement.getOwnerDocument();
            Element soapHeaderFaultElement = document.createElementNS("http://schemas.xmlsoap.org/wsdl/soap/", "headerfault");
            soapHeaderElement.appendChild(soapHeaderFaultElement);
            SOAPExtensionsTest.assertEquals((int)1, (int)soapHeader.getSOAPHeaderFaults().size());
            soapHeaderFaultElement.setAttribute("message", "tns:TestMsg");
            org.eclipse.wst.wsdl.binding.soap.SOAPHeaderFault soapHeaderFault = (org.eclipse.wst.wsdl.binding.soap.SOAPHeaderFault)soapHeader.getSOAPHeaderFaults().get(0);
            SOAPExtensionsTest.assertEquals((Object)testMessageQName, (Object)soapHeaderFault.getMessage());
            SOAPExtensionsTest.assertEquals((Object)testMessage, (Object)soapHeaderFault.getEMessage());
            BindingFault bindingFault = (BindingFault)bindingOperation.getBindingFault("fault");
            extensibilityElements = bindingFault.getExtensibilityElements();
            SOAPExtensionsTest.assertEquals((int)1, (int)extensibilityElements.size());
            SOAPFault soapFault = (SOAPFault)extensibilityElements.get(0);
            String name = soapFault.getName();
            SOAPExtensionsTest.assertEquals((String)"fault", (String)name);
            this.checkStringAttributeReconciliation((WSDLElement)soapFault, "name", "test", (EStructuralFeature)SOAPPackage.Literals.SOAP_FAULT__NAME);
            soapFault.setNamespaceURI("http://www.example.com/test");
            this.checkStringAttributeReconciliation((WSDLElement)soapFault, "namespace", "test", (EStructuralFeature)SOAPPackage.Literals.SOAP_FAULT__NAMESPACE_URI);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    private void addSOAPAddress(Definition definition) {
        SOAPAddress soapAddress = SOAP_FACTORY.createSOAPAddress();
        soapAddress.setLocationURI(LOCATION_URI);
        soapAddress.toString();
        String serviceName = "SOAPTest";
        QName serviceQName = new QName(definition.getTargetNamespace(), serviceName);
        Service service = (Service)definition.getService(serviceQName);
        service.toString();
        Port port = (Port)service.getPort("SOAPTestSOAP");
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        port.toString();
    }

    private void addSOAPBinding(Binding binding) {
        SOAPBinding soapBinding = SOAP_FACTORY.createSOAPBinding();
        soapBinding.setStyle(STYLE_DOCUMENT);
        soapBinding.setTransportURI(HTTP_TRANSPORT_URI);
        soapBinding.toString();
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        binding.toString();
    }

    private void addSOAPBindingFault(BindingFault bindingFault) {
        String faultName = bindingFault.getName();
        SOAPFault soapFault = SOAP_FACTORY.createSOAPFault();
        soapFault.setName(faultName);
        soapFault.toString();
        soapFault.setUse(USE_LITERAL);
        bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
        bindingFault.toString();
    }

    private void addSOAPBindingInput(BindingInput bindingInput) {
        bindingInput.toString();
        SOAPBody inputSOAPBody = SOAP_FACTORY.createSOAPBody();
        bindingInput.addExtensibilityElement((ExtensibilityElement)inputSOAPBody);
        inputSOAPBody.setUse(USE_LITERAL);
        ArrayList<Part> parts = new ArrayList<Part>();
        String messageName = "NewOperationRequest";
        Definition enclosingDefinition = bindingInput.getEnclosingDefinition();
        String targetNamespace = enclosingDefinition.getTargetNamespace();
        QName messageQName = new QName(targetNamespace, messageName);
        Definition definition = enclosingDefinition;
        Message message = (Message)definition.getMessage(messageQName);
        Part part = (Part)message.getPart("parameters");
        parts.add(part);
        inputSOAPBody.setParts(parts);
        inputSOAPBody.toString();
        SOAPHeader soapHeader = SOAP_FACTORY.createSOAPHeader();
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapHeader);
        soapHeader.setMessage(messageQName);
        String headerPart = "header";
        soapHeader.setPart(headerPart);
        soapHeader.setUse(USE_LITERAL);
        soapHeader.toString();
        this.addSOAPHeaderFault(messageQName, soapHeader);
    }

    private void addSOAPBindingOutput(BindingOutput bindingOutput) {
        SOAPBody soapBody = SOAP_FACTORY.createSOAPBody();
        soapBody.setUse(USE_ENCODED);
        BasicEList encodingStyles = new BasicEList();
        encodingStyles.add((Object)"http://schemas.xmlsoap.org/soap/encoding/");
        encodingStyles.add((Object)"test");
        soapBody.setEncodingStyles((List)encodingStyles);
        EList eEncodingStyles = soapBody.getEEncodingStyles();
        SOAPExtensionsTest.assertEquals((int)2, (int)eEncodingStyles.size());
        soapBody.toString();
        bindingOutput.toString();
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
    }

    private void addSOAPHeaderFault(QName messageQName, SOAPHeader soapHeader) {
        org.eclipse.wst.wsdl.binding.soap.SOAPHeaderFault soapHeaderFault = SOAP_FACTORY.createSOAPHeaderFault();
        soapHeader.addSOAPHeaderFault((SOAPHeaderFault)soapHeaderFault);
        List soapHeaderFaults = soapHeader.getSOAPHeaderFaults();
        SOAPExtensionsTest.assertEquals((int)1, (int)soapHeaderFaults.size());
        org.eclipse.wst.wsdl.binding.soap.SOAPHeaderFault expectedSoapHeaderFault = (org.eclipse.wst.wsdl.binding.soap.SOAPHeaderFault)soapHeaderFaults.get(0);
        SOAPExtensionsTest.assertEquals((Object)expectedSoapHeaderFault, (Object)soapHeaderFault);
        soapHeaderFault.setMessage(messageQName);
        String headerFaultPart = "headerFault1";
        soapHeaderFault.setPart(headerFaultPart);
        soapHeader.getSOAPHeaderFaults().clear();
    }

    private void addSOAPOperation(BindingOperation bindingOperation) {
        SOAPOperation soapOperation = SOAP_FACTORY.createSOAPOperation();
        soapOperation.setStyle(STYLE_DOCUMENT);
        soapOperation.setSoapActionURI(SOAP_ACTION_URI);
        soapOperation.toString();
        bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
        bindingOperation.toString();
    }
}

