/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.tests.performance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ReadOAGISXSDTestcase
extends PerformanceTestCase {
    public void testReadXSD() throws MalformedURLException, CoreException, FileNotFoundException, IOException {
        File dir;
        String oagis80Dir = System.getProperty("oagis80Dir");
        Assert.assertNotNull((Object)oagis80Dir);
        if (!oagis80Dir.endsWith("/") && !oagis80Dir.endsWith("\\")) {
            oagis80Dir = String.valueOf(oagis80Dir) + "/";
        }
        if ((dir = new File(String.valueOf(oagis80Dir) + "OAGIS8.0")).exists() && dir.isDirectory()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("sp");
            project.create(null);
            project.open(null);
            this.copy(dir, (IContainer)project);
            this.joinBackgroundJobs();
            final ArrayList xsds = new ArrayList();
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getName().endsWith(".xsd")) {
                        xsds.add(proxy.requestResource());
                    }
                    return true;
                }
            }, 1);
            this.tagAsSummary("Read XSD", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
            this.startMeasuring();
            Iterator it = xsds.iterator();
            while (it.hasNext()) {
                this.readXSD((IFile)it.next());
            }
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
        } else {
            ReadOAGISXSDTestcase.fail((String)dir.toString());
        }
    }

    private void joinBackgroundJobs() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
                catch (InterruptedException interruptedException) {}
                long start = System.currentTimeMillis();
                Display display = Display.getDefault();
                while (System.currentTimeMillis() - start < 5000L) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    private void copy(File src, IContainer dest) throws CoreException, FileNotFoundException {
        File[] children = src.listFiles();
        int i = 0;
        while (i < children.length) {
            String name = children[i].getName();
            if (children[i].isDirectory()) {
                IFolder folder = dest.getFolder((IPath)new Path(name));
                folder.create(true, true, null);
                this.copy(children[i], (IContainer)folder);
            } else if (name.endsWith(".xsd")) {
                IFile file = dest.getFile((IPath)new Path(name));
                file.create((InputStream)new FileInputStream(children[i]), true, null);
            }
            ++i;
        }
    }

    private void readXSD(IFile file) throws CoreException, IOException {
        InputStream is = file.getContents();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XSDResourceImpl resource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)"*.xsd"));
        resource.load(is, null);
        resource.getSchema();
    }
}

