/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.tests.utils;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

public class BuildClasspath
implements IPlatformRunnable {
    public Object run(Object args) throws Exception {
        ResourceBundle pluginRequires = ResourceBundle.getBundle("org.eclipse.wst.command.env.property.tools.ExplorerRequires");
        Enumeration<String> requireKeys = pluginRequires.getKeys();
        while (requireKeys.hasMoreElements()) {
            String key = requireKeys.nextElement();
            this.buildClasspath(pluginRequires.getString(key));
        }
        return IPlatformRunnable.EXIT_OK;
    }

    private void buildClasspath(String pluginId) throws Exception {
        Bundle bundle = Platform.getBundle((String)pluginId);
        String classpath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        String location = bundle.getLocation();
        ManifestElement[] classpaths = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
        if (classpaths != null) {
            int index = 0;
            while (index < classpaths.length) {
                String newPath = null;
                if (location.indexOf("org.eclipse.swt") != -1) {
                    Bundle[] bundles = Platform.getFragments((Bundle)bundle);
                    String newLocation = bundles[0].getLocation().substring(8);
                    String path = classpaths[index].getValue().replaceFirst("\\$ws\\$", "ws/win32");
                    newPath = String.valueOf(newLocation) + path;
                } else if (location.startsWith("update")) {
                    newPath = String.valueOf(location.substring(8)) + classpaths[index].getValue();
                } else if (location.startsWith("initial")) {
                    newPath = String.valueOf(location.substring(23)) + classpaths[index].getValue();
                } else if (location.startsWith("System")) {
                    String platformLocation = Platform.getInstallLocation().getURL().toString().substring(6);
                    newPath = String.valueOf(platformLocation) + "plugins/org.eclipse.osgi_3.0.1/" + classpaths[index].getValue();
                }
                System.out.print(String.valueOf(newPath) + ';');
                ++index;
            }
        }
    }
}

