/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.tests.A;
import org.eclipse.wst.common.frameworks.datamodel.tests.B;
import org.eclipse.wst.common.frameworks.datamodel.tests.C;
import org.eclipse.wst.common.tests.CommonTestsPlugin;

public class ValidationTest
extends TestCase {
    private static final String A = "A";
    private static final String B = "B";
    private static final String C = "C";
    private static final String[] allProperties = new String[]{"A", "B", "C"};
    private IStatus errorStatus = new Status(4, CommonTestsPlugin.PLUGIN_ID, 0, "error", null);
    private IStatus okStatus = IDataModelProvider.OK_STATUS;
    private IStatus status;
    private List validationList;
    private IDataModel dm;

    protected void setUp() throws Exception {
        super.setUp();
        this.dm = DataModelFactory.createDataModel((IDataModelProvider)new P());
        this.status = this.okStatus;
        this.validationList = new ArrayList();
    }

    public void _testBasicValidation() {
        int i = 0;
        while (i < 2) {
            boolean ok = i == 0;
            this.status = ok ? this.okStatus : this.errorStatus;
            this.validationList.clear();
            ValidationTest.assertTrue((this.dm.isValid() == ok ? 1 : 0) != 0);
            ValidationTest.assertEquals((int)(ok ? 5 : 1), (int)this.validationList.size());
            ValidationTest.assertTrue((this.validationList.contains(A) || this.validationList.contains("IDataModelProperties.ALLOW_EXTENSIONS") || this.validationList.contains("IDataModelProperties.RESTRICT_EXTENSIONS") ? 1 : 0) != 0);
            if (ok) {
                ValidationTest.assertTrue((boolean)this.validationList.contains(B));
                ValidationTest.assertTrue((boolean)this.validationList.contains(C));
            }
            this.validationList.clear();
            ValidationTest.assertTrue((this.dm.validate().isOK() == ok ? 1 : 0) != 0);
            ValidationTest.assertTrue((this.validationList.contains(A) || this.validationList.contains("IDataModelProperties.ALLOW_EXTENSIONS") || this.validationList.contains("IDataModelProperties.RESTRICT_EXTENSIONS") ? 1 : 0) != 0);
            if (ok) {
                ValidationTest.assertTrue((boolean)this.validationList.contains(B));
                ValidationTest.assertTrue((boolean)this.validationList.contains(C));
            }
            this.validationList.clear();
            ValidationTest.assertTrue((this.dm.validate(true).isOK() == ok ? 1 : 0) != 0);
            ValidationTest.assertEquals((int)(ok ? 5 : 1), (int)this.validationList.size());
            this.validationList.clear();
            ValidationTest.assertTrue((this.dm.validate(false).isOK() == ok ? 1 : 0) != 0);
            ValidationTest.assertEquals((int)5, (int)this.validationList.size());
            ValidationTest.assertTrue((boolean)this.validationList.contains(A));
            ValidationTest.assertTrue((boolean)this.validationList.contains(B));
            ValidationTest.assertTrue((boolean)this.validationList.contains(C));
            this.validationList.clear();
            int j = 0;
            while (j < allProperties.length) {
                ValidationTest.assertTrue((this.dm.isPropertyValid(allProperties[j]) == ok ? 1 : 0) != 0);
                ValidationTest.assertEquals((int)1, (int)this.validationList.size());
                ValidationTest.assertTrue((boolean)this.validationList.contains(allProperties[j]));
                this.validationList.clear();
                ValidationTest.assertTrue((this.dm.validateProperty(allProperties[j]).isOK() == ok ? 1 : 0) != 0);
                ValidationTest.assertEquals((int)1, (int)this.validationList.size());
                ValidationTest.assertTrue((boolean)this.validationList.contains(allProperties[j]));
                this.validationList.clear();
                ++j;
            }
            ++i;
        }
    }

    public void testNestedValidation() {
        this.dm.addNestedModel("a", DataModelFactory.createDataModel((IDataModelProvider)new A()));
        this.dm.addNestedModel("b", DataModelFactory.createDataModel((IDataModelProvider)new B()));
        this.dm.addNestedModel("c", DataModelFactory.createDataModel((IDataModelProvider)new C()));
        int i = 0;
        while (i < 4) {
            this.validationList.clear();
            switch (i) {
                case 0: {
                    ValidationTest.assertTrue((boolean)this.dm.isValid());
                    break;
                }
                case 1: {
                    ValidationTest.assertTrue((boolean)this.dm.validate().isOK());
                    break;
                }
                case 2: {
                    ValidationTest.assertTrue((boolean)this.dm.validate(true).isOK());
                    break;
                }
                case 3: {
                    ValidationTest.assertTrue((boolean)this.dm.validate(false).isOK());
                }
            }
            ValidationTest.assertEquals((int)8, (int)this.validationList.size());
            ValidationTest.assertTrue((boolean)this.validationList.contains(A));
            ValidationTest.assertTrue((boolean)this.validationList.contains(B));
            ValidationTest.assertTrue((boolean)this.validationList.contains(C));
            ValidationTest.assertTrue((boolean)this.validationList.contains("a"));
            ValidationTest.assertTrue((boolean)this.validationList.contains("b"));
            ValidationTest.assertTrue((boolean)this.validationList.contains("c"));
            this.validationList.clear();
            ++i;
        }
        this.status = this.errorStatus;
        i = 0;
        while (i < 3) {
            this.validationList.clear();
            switch (i) {
                case 0: {
                    ValidationTest.assertTrue((!this.dm.isValid() ? 1 : 0) != 0);
                    break;
                }
                case 1: {
                    ValidationTest.assertTrue((!this.dm.validate().isOK() ? 1 : 0) != 0);
                    break;
                }
                case 2: {
                    ValidationTest.assertTrue((!this.dm.validate(true).isOK() ? 1 : 0) != 0);
                }
            }
            this.validationList.clear();
            ++i;
        }
        ValidationTest.assertTrue((!this.dm.validate(false).isOK() ? 1 : 0) != 0);
        ValidationTest.assertEquals((int)8, (int)this.validationList.size());
        ValidationTest.assertTrue((boolean)this.validationList.contains(A));
        ValidationTest.assertTrue((boolean)this.validationList.contains(B));
        ValidationTest.assertTrue((boolean)this.validationList.contains(C));
        ValidationTest.assertTrue((boolean)this.validationList.contains("a"));
        ValidationTest.assertTrue((boolean)this.validationList.contains("b"));
        ValidationTest.assertTrue((boolean)this.validationList.contains("c"));
        this.validationList.clear();
    }

    private class P
    extends AbstractDataModelProvider {
        private P() {
        }

        public Set getPropertyNames() {
            Set propertyNames = super.getPropertyNames();
            propertyNames.add(ValidationTest.A);
            propertyNames.add(ValidationTest.B);
            propertyNames.add(ValidationTest.C);
            return propertyNames;
        }

        public IStatus validate(String propertyName) {
            ValidationTest.this.validationList.add(propertyName);
            return ValidationTest.this.status;
        }
    }
}

