/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests;

import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.IWorkspaceRunnableWithStatus;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.tests.BaseTestCase;
import org.eclipse.wst.common.tests.DataModelVerifier;
import org.eclipse.wst.common.tests.DataModelVerifierFactory;
import org.eclipse.wst.common.tests.PostBuildListener;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.TaskViewUtility;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;

public abstract class OperationTestCase
extends BaseTestCase {
    public static final String VALIDATOR_JOB_FAMILY = "validators";
    public static String fileSep = System.getProperty("file.separator");
    public static IStatus OK_STATUS = new Status(0, "org.eclipse.jem.util", 0, "OK", null);

    protected void setUp() throws Exception {
        super.setUp();
        try {
            OperationTestCase.deleteAllProjects();
        }
        finally {
            RendererFactory.getDefaultRendererFactory().setValidating(false);
        }
    }

    public static void deleteAllProjects() {
        try {
            OperationTestCase.waitOnJobs();
        }
        catch (InterruptedException interruptedException) {}
        IWorkspaceRunnableWithStatus workspaceRunnable = new IWorkspaceRunnableWithStatus(null){

            public void run(IProgressMonitor pm) throws CoreException {
                try {
                    ProjectUtility.deleteAllProjects();
                }
                catch (Exception exception) {}
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, null);
        }
        catch (CoreException coreException) {}
    }

    public OperationTestCase() {
        super("OperationsTestCase");
    }

    public OperationTestCase(String name) {
        super(name);
    }

    public static void runAndVerify(IDataModel dataModel) throws Exception {
        OperationTestCase.runAndVerify(dataModel, true, true);
    }

    public static void runDataModel(IDataModel dataModel) throws Exception {
        OperationTestCase.runDataModel(dataModel, true, true);
    }

    public static void runDataModel(IDataModel dataModel, boolean checkTasks, boolean checkLog) throws Exception {
        OperationTestCase.runDataModel(dataModel, checkTasks, checkLog, null, true, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, null, true, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, null, true, waitForBuildToComplete);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, errorOKList, reportIfExpectedErrorNotFound, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runAndVerify(dataModel, checkTasks, checkLog, errorOKList, reportIfExpectedErrorNotFound, waitForBuildToComplete, false);
    }

    public static void runDataModel(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete) throws Exception {
        OperationTestCase.runDataModel(dataModel, checkTasks, checkLog, errorOKList, reportIfExpectedErrorNotFound, waitForBuildToComplete, false);
    }

    public static void runAndVerify(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete, boolean removeAllSameTypesOfErrors) throws Exception {
        PostBuildListener listener = null;
        IWorkspaceDescription desc = null;
        try {
            if (waitForBuildToComplete) {
                listener = new PostBuildListener();
                desc = ResourcesPlugin.getWorkspace().getDescription();
                desc.setAutoBuilding(false);
                ResourcesPlugin.getWorkspace().setDescription(desc);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
            }
            BaseTestCase.failOnLoggedStatus(checkLog);
            IStatus operationStatus = dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (waitForBuildToComplete) {
                desc.setAutoBuilding(true);
                ResourcesPlugin.getWorkspace().setDescription(desc);
                while (!listener.isBuildComplete()) {
                    Thread.sleep(3000L);
                }
            }
            if (operationStatus.getSeverity() == 4) {
                Throwable throwable = operationStatus.getException();
                String throwableStr = null;
                if (throwable != null) {
                    throwable.printStackTrace();
                    throwableStr = OperationTestCase.getStackTrace(throwable);
                }
                if (throwableStr == null) {
                    throwableStr = "no message";
                }
                Assert.fail((String)(String.valueOf(operationStatus.getMessage()) + "\n    caused by: " + throwableStr));
            }
            DataModelVerifierFactory verifierFactory = DataModelVerifierFactory.getInstance();
            DataModelVerifier verifier = verifierFactory.createVerifier(dataModel);
            verifier.verify(dataModel);
            if (checkTasks && (errorOKList == null || errorOKList.isEmpty())) {
                OperationTestCase.checkTasksList();
            } else if (checkTasks && errorOKList != null && !errorOKList.isEmpty()) {
                TaskViewUtility.verifyErrors(errorOKList, reportIfExpectedErrorNotFound, removeAllSameTypesOfErrors);
            }
        }
        finally {
            if (listener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
            }
            dataModel.dispose();
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringBuffer buffer = new StringBuffer(String.valueOf(throwable.toString()) + "\n");
        StackTraceElement[] stack = throwable.getStackTrace();
        int i = 0;
        while (i < stack.length) {
            buffer.append("\tat " + stack[i] + "\n");
            ++i;
        }
        throwable = throwable.getCause();
        while (throwable != null) {
            buffer.append("Caused by: ");
            buffer.append(throwable);
            buffer.append("\n");
            StackTraceElement[] currentStack = throwable.getStackTrace();
            throwable = throwable.getCause();
        }
        return buffer.toString();
    }

    public static void runDataModel(IDataModel dataModel, boolean checkTasks, boolean checkLog, List errorOKList, boolean reportIfExpectedErrorNotFound, boolean waitForBuildToComplete, boolean removeAllSameTypesOfErrors) throws Exception {
        PostBuildListener listener = null;
        IWorkspaceDescription desc = null;
        try {
            if (waitForBuildToComplete) {
                listener = new PostBuildListener();
                desc = ResourcesPlugin.getWorkspace().getDescription();
                desc.setAutoBuilding(false);
                ResourcesPlugin.getWorkspace().setDescription(desc);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
            }
            BaseTestCase.failOnLoggedStatus(checkLog);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (waitForBuildToComplete) {
                desc.setAutoBuilding(true);
                ResourcesPlugin.getWorkspace().setDescription(desc);
                while (!listener.isBuildComplete()) {
                    Thread.sleep(3000L);
                }
            }
            if (checkTasks && (errorOKList == null || errorOKList.isEmpty())) {
                OperationTestCase.checkTasksList();
            } else if (checkTasks && errorOKList != null && !errorOKList.isEmpty()) {
                TaskViewUtility.verifyErrors(errorOKList, reportIfExpectedErrorNotFound, removeAllSameTypesOfErrors);
            }
        }
        finally {
            if (listener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
            }
            dataModel.dispose();
        }
    }

    protected static void checkTasksList() {
    }

    public static void verifyValidDataModel(IDataModel dataModel) {
        IStatus status = dataModel.validate();
        if (!status.isOK() && status.getSeverity() == 4) {
            Assert.assertTrue((String)("DataModel is invalid operation will not run:" + status.toString()), (boolean)false);
        }
    }

    public static void verifyInvalidDataModel(IDataModel dataModel) {
        IStatus status = dataModel.validate();
        if (status.isOK()) {
            Assert.assertTrue((String)("DataModel should be invalid:" + status.getMessage()), (boolean)false);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        OperationTestCase.waitOnJobs();
    }

    public static void waitOnJobs() throws InterruptedException {
        IProject[] projects = ProjectUtility.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            Job.getJobManager().join((Object)(String.valueOf(project.getName()) + VALIDATOR_JOB_FAMILY), null);
            ++i;
        }
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        Job.getJobManager().join(ValidationBuilder.FAMILY_VALIDATION_JOB, null);
    }
}

