/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.genapi.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleDocTask
extends Task {
    protected String _bundleId;
    protected String _fileName;
    protected String _delim = ",";

    public void setBundleid(String bundleId) {
        this._bundleId = bundleId;
    }

    public void setFilename(String fileName) {
        this._fileName = fileName;
    }

    public void setDelimiter(String delim) {
        this._delim = delim;
    }

    public void execute() throws BuildException {
        block5: {
            Assert.isNotNull((Object)this._fileName);
            Assert.isNotNull((Object)this._bundleId);
            try {
                if (this._bundleId.trim().equals("")) {
                    return;
                }
                Bundle bundle = Platform.getBundle((String)this._bundleId);
                if (bundle != null) {
                    List<String> result = this.getResults(bundle);
                    if (result.size() > 0) {
                        this.writeResults(result);
                    }
                    break block5;
                }
                throw new BuildException("Bundle '" + this._bundleId + "' was not located.");
            }
            catch (BundleException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected abstract List<String> getResults(Bundle var1) throws BundleException;

    protected void writeResults(List<String> results) throws BuildException {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            try {
                fstream = new FileWriter(this._fileName, true);
                out = new BufferedWriter(fstream);
                for (String result : results) {
                    out.write(result);
                    out.write(this._delim);
                    out.write("\n");
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }
}

