/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.genapi.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.genapi.util.BundleDocTask;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseBundleSourceFolders
extends BundleDocTask {
    @Override
    protected List<String> getResults(Bundle bundle) throws BundleException {
        ArrayList<String> result = new ArrayList<String>();
        IJavaProject proj = this.getJavaProject(bundle);
        if (proj != null) {
            try {
                IClasspathEntry[] cps = proj.getRawClasspath();
                int i = 0;
                while (i < cps.length) {
                    IClasspathEntry cp = cps[i];
                    if (cp.getEntryKind() == 3) {
                        result.add(cp.getPath().toString());
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                throw new BuildException((Throwable)e);
            }
        }
        return result;
    }

    private IJavaProject getJavaProject(Bundle bundle) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle.getSymbolicName());
        if (proj != null && proj.isAccessible()) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }
}

