/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.genapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.eclipse.jst.jsf.genapi.util.ParseAPIPackages;

public class TestParseAPIPackages
extends TestCase {
    private String _apisFileName = "c:/temp/apiPackages.txt";

    public void testParse() throws Exception {
        ParseAPIPackages parser = new ParseAPIPackages();
        parser.setBundleid("org.eclipse.jst.jsf.core");
        parser.setFilename(this._apisFileName);
        parser.execute();
        File file = this.getTempFile();
        Assert.assertTrue((boolean)file.exists());
        long size1 = file.length();
        Assert.assertTrue((size1 > 600L ? 1 : 0) != 0);
        parser.setBundleid("org.eclipse.jst.pagedesigner");
        parser.execute();
        Assert.assertTrue((size1 < file.length() ? 1 : 0) != 0);
    }

    public void testParseFC() throws Exception {
        ParseAPIPackages parser = new ParseAPIPackages();
        parser.setBundleid("org.eclipse.jst.jsf.common.ui");
        parser.setFilename(this._apisFileName);
        parser.execute();
    }

    public void testBadPluginId() throws Exception {
        try {
            ParseAPIPackages parser = new ParseAPIPackages();
            parser.setBundleid("org.eclipse.jst.jsf.BOGUS");
            parser.setFilename(this._apisFileName);
            parser.execute();
            TestParseAPIPackages.fail((String)"Expecting BuildException");
        }
        catch (BuildException parser) {
        }
        catch (Exception e2) {
            TestParseAPIPackages.fail((String)"Expecting BuildException");
        }
    }

    public void testEmptyPluginId() throws Exception {
        try {
            ParseAPIPackages parser = new ParseAPIPackages();
            parser.setBundleid("");
            parser.setFilename(this._apisFileName);
            parser.execute();
        }
        catch (BuildException e1) {
            TestParseAPIPackages.fail((String)"Expecting no error");
        }
        catch (Exception e2) {
            TestParseAPIPackages.fail((String)"Expecting no error");
        }
    }

    public void testDelimiter() throws Exception {
        String delim = "$$";
        ParseAPIPackages parser = new ParseAPIPackages();
        parser.setBundleid("org.eclipse.jst.jsf.core");
        parser.setFilename(this._apisFileName);
        parser.setDelimiter("$$");
        parser.execute();
        File file = this.getTempFile();
        Assert.assertTrue((boolean)file.exists());
        FileReader fr = null;
        BufferedReader reader = null;
        try {
            fr = new FileReader(file);
            reader = new BufferedReader(fr);
            String line1 = reader.readLine();
            Assert.assertTrue((String)"Expected line to end with: $$", (boolean)line1.endsWith("$$"));
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void testExceptions() throws Exception {
        String apiExceptionsList = "org.eclipse.jst.jsf.common.util,org.eclipse.jst.jsf.contentmodel.annotation";
        ParseAPIPackages parser = new ParseAPIPackages();
        parser.setBundleid("org.eclipse.jst.jsf.common");
        parser.setFilename(this._apisFileName);
        parser.setExceptionlist("org.eclipse.jst.jsf.common.util,org.eclipse.jst.jsf.contentmodel.annotation");
        parser.setDelimiter("");
        parser.execute();
        File file = this.getTempFile();
        Assert.assertTrue((boolean)file.exists());
        FileReader fr = null;
        BufferedReader reader = null;
        try {
            String line;
            fr = new FileReader(file);
            reader = new BufferedReader(fr);
            HashSet<String> results = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                results.add(line);
            }
            Assert.assertFalse((boolean)results.contains("org.eclipse.jst.jsf.common.util"));
            Assert.assertFalse((boolean)results.contains("org.eclipse.jst.jsf.contentmodel.annotation"));
            Assert.assertTrue((boolean)results.contains("org.eclipse.jst.jsf.common.dom"));
            Assert.assertTrue((boolean)results.contains("org.eclipse.jst.jsf.context.symbol.source"));
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void setUp() throws Exception {
        this.deleteTempFile();
    }

    public void tearDown() throws Exception {
        this.deleteTempFile();
    }

    private void deleteTempFile() {
        File file = this.getTempFile();
        if (file.exists()) {
            file.delete();
        }
    }

    private File getTempFile() {
        return new File(this._apisFileName);
    }
}

