/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.genapi.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.genapi.util.BundleDocTask;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseAPIPackages
extends BundleDocTask {
    protected Set<String> _exceptionsList = new HashSet<String>();

    @Override
    protected List<String> getResults(Bundle bundle) throws BundleException {
        ArrayList<String> result = new ArrayList<String>();
        Dictionary allHeaders = bundle.getHeaders();
        String exportPackageHeader = (String)allHeaders.get("Export-Package");
        if (exportPackageHeader != null) {
            ManifestElement[] exportPackages = ManifestElement.parseHeader((String)"Export-Package", (String)exportPackageHeader);
            int i = 0;
            while (i < exportPackages.length) {
                ManifestElement element = exportPackages[i];
                if (element.getDirectiveKeys() == null && element.getKeys() == null && !this.isAPIException(element.getValue().trim())) {
                    result.add(element.getValue().trim());
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isAPIException(String api) {
        return this._exceptionsList.contains(api);
    }

    public void setExceptionlist(String exceptionsList) {
        Assert.isNotNull((Object)exceptionsList);
        this._exceptionsList = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(exceptionsList, ",");
        while (st.hasMoreTokens()) {
            this._exceptionsList.add(st.nextToken().trim());
        }
    }
}

