/*******************************************************************************
 * Copyright (c) 2004, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.jsp.ui.tests.performance;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

/**
 * @author davidw
 */
public class TestInsertPerformance extends PerformanceTestCase {
	float total = 0;
	long thisTime = 0;
	int nTrials = 3; // 11;

	public TestInsertPerformance(String name) {
		super(name);
	}

	protected void doTestBigTable(String filename) throws IOException {
		for (int i = 0; i < nTrials; i++) {
			doTestBigTable(i, filename);
			// don't include first, since is 5 times longer than usual
			// presumably due to class loading
			if (i > 0) {
				total = total + thisTime;
			}
		}
		System.out.println();
		System.out.println("          Average Time to insert 1000 row table in " + filename + ": " + (total / (nTrials - 1))); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("          (used " + (nTrials - 1) + " trials)"); //$NON-NLS-1$ //$NON-NLS-2$

	}

	protected void doTestBigTable(int i, String filename) throws IOException {
		IModelManager modelManager = StructuredModelManager.getModelManager();
		// System.out.println();
		InputStream inStream = getClass().getResourceAsStream(filename);
		// // run garbage collection to get a little more consistent times.
		// System.gc();
		// System.gc();
		IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
		IStructuredDocument structuredDocument = model.getStructuredDocument();
		InputStream textStream = getClass().getResourceAsStream("bigTable.txt"); //$NON-NLS-1$
		String tableText = readInputStream(new InputStreamReader(textStream));
		long startTime = System.currentTimeMillis();
		// 80 is known by counting characters in template, and trail and error
		structuredDocument.replaceText(this, 80, 0, tableText);
		long endTime = System.currentTimeMillis();
		thisTime = endTime - startTime;
		// System.out.println(i + ". Time to insert table text: " + thisTime);
		// String resultingText = structuredDocument.getText();
		// System.out.println(resultingText);
		model.releaseFromEdit();
		inStream.close();
		textStream.close();

	}

	/**
	 * This method is quick/easy way to read "plain" (ascii) characters from
	 * inputstream.
	 */
	private String readInputStream(InputStreamReader inputStreamReader) throws IOException {
		int numRead = 0;
		StringBuffer buffer = new StringBuffer();
		char tBuff[] = new char[4000];
		while ((numRead = inputStreamReader.read(tBuff, 0, tBuff.length)) != -1) {
			buffer.append(tBuff, 0, numRead);
		}
		return buffer.toString();
	}

	public void testHTMLInsert() throws IOException {
		startMeasuring();
		doTestBigTable("plainTemplate.html"); //$NON-NLS-1$
		stopMeasuring();
		commitMeasurements();
		assertPerformance();
	}

	public void testXMLInsert() throws IOException {
		startMeasuring();
		doTestBigTable("plainTemplate.xml"); //$NON-NLS-1$
		stopMeasuring();
		commitMeasurements();
		assertPerformance();
	}

	public void testJSPInsert() throws IOException {
		startMeasuring();
		doTestBigTable("plainTemplate.jsp"); //$NON-NLS-1$
		stopMeasuring();
		commitMeasurements();
		assertPerformance();
	}
}
