package org.eclipse.wst.common.tests.performance.internal.scalability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;

public abstract class RepeatOpenEditorTestCase extends ScalabilityTestCase
{
  protected abstract int getRepeatCount();
  protected abstract String getEditorId();
  protected abstract String getBundleId();
  protected abstract String getFilePath();

  protected List files = new ArrayList();

  protected void setUp() throws Exception
  {
    super.setUp();
  }

  public void execute() throws Exception
  {
    IProject project = createProject("sp");
    String bundleId = getBundleId();
    String filePath = getFilePath();
    int count = getRepeatCount();
    for (int i = 0; i < count; i++)
      files.add(copyFile(bundleId, filePath, project, String.valueOf(i)));
    joinBackgroundJobs(3000);
    tagAsSummary(getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
    startMeasuring();
    String editorId = getEditorId();
    for (Iterator it = files.iterator(); it.hasNext();)
      openEditor(editorId, (IFile)it.next());
    stopMeasuring();
    commitMeasurements();
    assertPerformance();
  }

  protected void openEditor(String editorId, IFile file) throws PartInitException
  {
    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    IEditorPart editor = workbenchWindow.getActivePage().openEditor(new FileEditorInput(file), editorId, true);
    EditorTestHelper.runEventQueue(editor);
    workbenchWindow.getActivePage().closeEditor(editor, false);
    try
    {
      EditorTestHelper.joinBackgroundActivities();
    }
    catch (CoreException e)
    {
      fail(e.getMessage());
    }
  }
}