package org.eclipse.wst.common.tests.performance.internal.scalability;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.test.performance.Dimension;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;

public abstract class RunValidatorTestCase extends ScalabilityTestCase
{
  protected abstract String getValidatorId();
  protected abstract String getBundleId();
  protected abstract String getFilePath();

  protected IFile file;

  protected void setUp() throws Exception
  {
    super.setUp();
    IProject project = createProject("sp");
    String bundleId = getBundleId();
    file = copyFile(bundleId, getFilePath(), project);
    joinBackgroundJobs(3000);
  }

  public void execute() throws Exception
  {
    tagAsSummary(getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
    startMeasuring();
    runValidator(file);
    stopMeasuring();
    commitMeasurements();
    assertPerformance();
  }

  protected void runValidator(IFile file) throws CoreException, ValidationException
  {
    OneValidatorOperation operation = new OneValidatorOperation(file.getProject(), getValidatorId(), true, false);
    operation.run(new NullProgressMonitor());
    try
    {
      EditorTestHelper.joinBackgroundActivities();
    }
    catch (CoreException e)
    {
      fail(e.getMessage());
    }
  }
  
  protected void tearDown() throws Exception
  {
    super.tearDown();
    deleteProject("sp");
  }
}