package org.eclipse.wtp.releng.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * This class was original based on TestResultsGenerator.java from the
 * org.eclilpse.build.tools project in the basebuilder.
 * 
 */
public class ResultsSummaryGenerator extends Task {

	private static final String WARNING_SEVERITY = "WARNING";
	private static final String ERROR_SEVERITY = "ERROR";
	private static final String ForbiddenReferenceID = "ForbiddenReference";
	private static final String DiscouragedReferenceID = "DiscouragedReference";

	private static final int DEFAULT_READING_SIZE = 8192;
	private String EOL = System.getProperty("line.separator");

	private static final String TEST_SUITE_ELEMENT_NAME = "testsuite";
	private static final String testResultsToken = "%testresults%";
	private static final String compileLogsToken = "%compilelogs%";
	public Vector dropTokens;
	public Vector platformSpecs;
	public Vector differentPlatforms;
	public String testResultsWithProblems = EOL;

	private DocumentBuilder parser = null;
	public String testResultsTemplateString = "";
	public String dropTemplateString = "";

	public Vector platformDescription;
	public Vector platformTemplateString;
	public Vector platformDropFileName;

	// Status of tests results (pending, successful, failed), used to specify
	// the color
	// of the test Results link on the build pages (standard, green, red),
	// once failures
	// are encountered, this is set to failed
	// protected String testResultsStatus = "successful";
	// assume tests ran. If no html files are found, this is set to false
	private boolean testsRan = true;

	// Parameters
	// build runs JUnit automated tests
	private boolean isBuildTested;

	// buildType, I, N
	public String buildType;

	// Comma separated list of drop tokens
	public String dropTokenList;

	// Token in platform.php.template to be replaced by the desired platform
	// ID
	public String platformIdentifierToken;

	// Location of the xml files
	public String xmlDirectoryName;

	// Location of the html files
	public String htmlDirectoryName;

	// Location of the resulting index.php file.
	public String dropDirectoryName;

	// Location and name of the template index.php file.
	public String testResultsTemplateFileName;

	// Platform specific template and output list (colon separated) in the
	// following format:
	// <descriptor, ie. OS name>,path to template file, path to output file
	// public String platformSpecificTemplateList = "";

	// Name of the generated index php file.
	public String testResultsHtmlFileName;

	// Name of the generated drop index php file;
	public String dropHtmlFileName;

	// Arbitrary path used in the index.php page to href the
	// generated .html files.
	public String hrefTestResultsTargetPath;

	// Aritrary path used in the index.php page to reference the compileLogs
	public String hrefCompileLogsTargetPath;

	// Location of compile logs base directory
	public String compileLogsDirectoryName;

	// Location and name of test manifest file
	public String testManifestFileName;

	private FullJarNameParser nameParser = new FullJarNameParser();

	private static class UnitTestResults {
		private int errors = -99;
		private int failures = -99;
		private int totalTests = -99;
		private float time = -99;
		
		int getErrors() {
			return errors;
		}

		void setErrors(int errors) {
			this.errors = errors;
		}

		int getFailures() {
			return failures;
		}

		void setFailures(int failures) {
			this.failures = failures;
		}

		int getTotalTests() {
			return totalTests;
		}

		void setTotalTests(int totalTests) {
			this.totalTests = totalTests;
		}

		public float getTime() {
			return time;
		}

		public void setTime(float time) {
			this.time = time;
		}

	}

	public static void main(String[] args) {
		ResultsSummaryGenerator test = new ResultsSummaryGenerator();
		test.setDropTokenList("%sdk%,%tests%,%example%,%rcpruntime%,%rcpsdk%,%icubase%,%runtime%,%platformsdk%,%jdt%,%jdtsdk%,%pde%,%pdesdk%,%cvs%,%cvssdk%,%teamextras%,%swt%,%relengtools%");
		test.setPlatformIdentifierToken("%platform%");
		test.getDropTokensFromList(test.dropTokenList);
		test.setIsBuildTested(true);
		test.setXmlDirectoryName("C:\\junk\\testresults\\xml");
		test.setHtmlDirectoryName("C:\\junk\\testresults");
		test.setDropDirectoryName("C:\\junk");
		test.setTestResultsTemplateFileName("C:\\junk\\templateFiles\\testResults.php.template");
		// test.setPlatformSpecificTemplateList("Windows,C:\\junk\\templateFiles\\platform.php.template,winPlatform.php;Linux,C:\\junk\\templateFiles\\platform.php.template,linPlatform.php;Solaris,C:\\junk\\templateFiles\\platform.php.template,solPlatform.php;AIX,C:\\junk\\templateFiles\\platform.php.template,aixPlatform.php;Macintosh,C:\\junk\\templateFiles\\platform.php.template,macPlatform.php;Source
		// Build,C:\\junk\\templateFiles\\sourceBuilds.php.template,sourceBuilds.php");
		test.setTestResultsHtmlFileName("testResults.php");
		// test.setDropHtmlFileName("index.php");
		test.setDropHtmlFileName("index.html");

		test.setHrefTestResultsTargetPath("testresults");
		test.setCompileLogsDirectoryName("C:\\junk\\compilelogs\\plugins");
		test.setHrefCompileLogsTargetPath("compilelogs");
		test.setTestManifestFileName("C:\\junk\\testManifest.xml");
		test.execute();
	}

	public void execute() {

		try {
			getDropTokensFromList(dropTokenList);
			testResultsTemplateString = readFile(testResultsTemplateFileName);
			// dropTemplateString = readFile(dropTemplateFileName);

			// Specific to the platform build-page
			/*
			 * if (platformSpecificTemplateList != "") { String description,
			 * platformTemplateFile, platformDropFile; // Retrieve the
			 * different platforms and their info
			 * getDifferentPlatformsFromList(platformSpecificTemplateList); //
			 * Parses the platform info and retrieves the platform name, //
			 * template file, and drop file for (int i = 0; i <
			 * differentPlatforms.size(); i++) {
			 * getPlatformSpecsFromList(differentPlatforms.get(i).toString());
			 * description = platformSpecs.get(0).toString();
			 * platformTemplateFile = platformSpecs.get(1).toString();
			 * platformDropFile = platformSpecs.get(2).toString();
			 * platformDescription.add(description);
			 * platformTemplateString.add(readFile(platformTemplateFile));
			 * platformDropFileName.add(platformDropFile); } }
			 */

			System.out.println("Begin: Generating test results index page");
			System.out.println("Parsing XML files");
			parseUnitTestXml();
			System.out.println("Parsing compile logs");
			parseCompileLogs();
			System.out.println("End: Generating test results index page");
			writeTestResultsFile();
			// For the platform build-page, write platform files, in addition
			// to
			// the index file
			// if (platformSpecificTemplateList != "") {
			// writeDropFiles();
			// }
			// else {
			// }
		}
		catch (Exception e) {
			throw new BuildException(e);
		}
	}

	private void parseCompileLogs() throws TransformerFactoryConfigurationError, IOException, TransformerException {
		totalErrors = 0;
		totalAccess = 0;
		totalWarnings = 0;
		rowCount = 0;
		totaldiscouragedAccessWarningCount = 0;
		totalforbiddenAccessWarningCount = 0;

		StringBuffer replaceString = new StringBuffer();
		processCompileLogsDirectory(compileLogsDirectoryName, replaceString);

		writeFormattedTotals(replaceString);
		writeCompileSummaryTotalsAsXML(compileLogsDirectoryName);

		if (replaceString.length() == 0) {
			replaceString.append("None");
		}

		testResultsTemplateString = replace(testResultsTemplateString, compileLogsToken, String.valueOf(replaceString));

	}

	/**
	 * @param mainSummaryName
	 * @throws TransformerException
	 * @throws IOException
	 * @throws TransformerFactoryConfigurationError
	 */
	private void writeCompileSummaryTotalsAsXML(String mainSummaryName) throws TransformerFactoryConfigurationError, IOException, TransformerException {
		String outputFileName = mainSummaryName + "Summary" + ".xml";
		// debug
		// System.out.println("dropDirectoryName: " + dropDirectoryName);
		// System.out.println("outputFileName: " + outputFileName);
		// File fileDir = new File(dropDirectoryName);
		File file = new File(outputFileName);
		file.createNewFile();
		Node rootNode = createNewDOM("compileSummary");
		addSummaryNodeTo(rootNode, "totalBundles", rowCount);
		addSummaryNodeTo(rootNode, "totalErrors", totalErrors);
		addSummaryNodeTo(rootNode, "totalWarnings", totalWarnings);
		addSummaryNodeTo(rootNode, "totalAccess", totalAccess);
		addSummaryNodeTo(rootNode, "totaldiscouragedAccessWarningCount", totaldiscouragedAccessWarningCount);
		addSummaryNodeTo(rootNode, "totalforbiddenAccessWarningCount", totalforbiddenAccessWarningCount);
		serialize(rootNode, file);

	}

	private void serialize(Node rootNode, File outputFile) throws TransformerFactoryConfigurationError, IOException, TransformerException {
		// JAXP transformation
		Document sourceDocument = rootNode.getOwnerDocument();
		Source domSource = new DOMSource(sourceDocument);
		Transformer serializer = TransformerFactory.newInstance().newTransformer();
		try {
			serializer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
			serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch (IllegalArgumentException e) {
			// unsupported properties, so we'll just ignore
		}
		Writer outputWriter = null;
		try {
			outputWriter = new FileWriter(outputFile);
			serializer.transform(domSource, new StreamResult(outputWriter));
		}
		finally {
			if (outputWriter != null) {
				outputWriter.close();
			}
		}
	}

	/**
	 * <summaryItem> <name>someName</name> <value>8</value> </summaryItem>
	 * 
	 * @param dom
	 */
	private void addSummaryNodeTo(Node rootNode, String itemName, int intdata) {
		Document dom = rootNode.getOwnerDocument();
		Element summaryElement = dom.createElement("summaryItem");

		Element nameElement = dom.createElement("name");
		Element valueElement = dom.createElement("value");

		summaryElement.appendChild(nameElement);
		summaryElement.appendChild(valueElement);

		Text name = dom.createTextNode(itemName);
		Text value = dom.createTextNode(String.valueOf(intdata));
		nameElement.appendChild(name);
		valueElement.appendChild(value);

		rootNode.appendChild(summaryElement);
	}
	
	private void addSummaryNodeTo(Node rootNode, String itemName, float floatdata) {
		Document dom = rootNode.getOwnerDocument();
		Element summaryElement = dom.createElement("summaryItem");

		Element nameElement = dom.createElement("name");
		Element valueElement = dom.createElement("value");

		summaryElement.appendChild(nameElement);
		summaryElement.appendChild(valueElement);

		Text name = dom.createTextNode(itemName);
		Text value = dom.createTextNode(String.valueOf(floatdata));
		nameElement.appendChild(name);
		valueElement.appendChild(value);

		rootNode.appendChild(summaryElement);
	}

	private Node createNewDOM(String rootElementName) {
		Document document = null;
		Node rootNode = null;
		try {
			document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
		}
		catch (ParserConfigurationException e) {
			log("exception creating document: " + e.getMessage()); //$NON-NLS-1$
		}
		catch (FactoryConfigurationError e) {
			log("exception creating document: " + e.getMessage()); //$NON-NLS-1$
		}
		if (document != null) {
			rootNode = document.appendChild(document.createElement(rootElementName));
		}
		return rootNode;
	}

	private void processCompileLogsDirectory(String directoryName, StringBuffer buffer) {
		if (buffer == null) {
			throw new RuntimeException("write buffer can not be null");
		}
		File sourceDirectory = new File(directoryName);

		if (sourceDirectory.exists()) {
			if (sourceDirectory.isFile()) {
				if (sourceDirectory.getName().endsWith(".log"))
					readCompileLog(sourceDirectory.getAbsolutePath(), buffer);
				if (sourceDirectory.getName().endsWith(".xml"))
					parseCompileLog(sourceDirectory.getAbsolutePath(), buffer);
			}
			if (sourceDirectory.isDirectory()) {
				File[] logFiles = sourceDirectory.listFiles();
				Arrays.sort(logFiles);
				for (int j = 0; j < logFiles.length; j++) {
					processCompileLogsDirectory(logFiles[j].getAbsolutePath(), buffer);
				}
			}
		}
		else {
			if (directoryName.length() > 0) {
				log("Directory did not exist: " + directoryName);
			}
		}

	}

	/**
	 * 
	 */
	private void writeFormattedTotals(StringBuffer buffer) {

		if (buffer == null) {
			throw new RuntimeException("write buffer can not be null");
		}

		String rowtype = "normaltable";
		if (totalErrors > 0) {
			rowtype = "errortable";
		}
		else if (totalWarnings > 0) {
			rowtype = "warningtable";
			if (totalWarnings > 200) {
				rowtype = "extraWarningTable";
			}
		}
		//
		// System.out.println("totalErrors: " + totalErrors); // ,
		// log("totalErrors: " + totalErrors, Project.MSG_INFO);

		buffer.append("<tr CLASS=\"" + rowtype + " " + "bold" + "\">" + EOL).append("<td>" + "TOTALS  (" + rowCount + ")" + "</td>").append("<td CLASS=\"numeric\">" + totalErrors + "</td>").append("<td CLASS=\"numeric\">" + totalWarnings + "</td>").append("<td CLASS=\"numeric\">" + totalforbiddenAccessWarningCount + "</td>").append("<td CLASS=\"numeric\">" + totaldiscouragedAccessWarningCount + "</td>").append(EOL + "</tr>" + EOL);

	}

	private void readCompileLog(String log, StringBuffer buffer) {
		String fileContents = readFile(log);

		int errorCount = countCompileErrors(fileContents);
		int warningCount = countCompileWarnings(fileContents);
		int forbiddenWarningCount = countForbiddenWarnings(fileContents);
		int discouragedWarningCount = countDiscouragedWarnings(fileContents);
		// use wildcard in place of version number on directory names
		String logName = log.substring(getCompileLogsDirectoryName().length() + 1);
		StringBuffer stringBuffer = new StringBuffer(logName);
		stringBuffer.replace(logName.indexOf("_") + 1, logName.indexOf(File.separator, logName.indexOf("_") + 1), "*");
		logName = new String(stringBuffer);
		formatCompileErrorRow(log, errorCount, warningCount, forbiddenWarningCount, discouragedWarningCount, buffer);
	}

	private void parseCompileLog(String log, StringBuffer stringBuffer) {
		int errorCount = 0;
		int warningCount = 0;
		int forbiddenWarningCount = 0;
		int discouragedWarningCount = 0;

		File file = new File(log);
		Document aDocument = null;
		BufferedReader reader = null;
		try {
			reader = new BufferedReader(new FileReader(file));
			InputSource inputSource = new InputSource(reader);
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			aDocument = builder.parse(inputSource);
		}
		catch (SAXException e) {
			e.printStackTrace();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
		finally {
			if (reader != null) {
				try {
					reader.close();
				}
				catch (IOException e) {
					// ignore
				}
			}
		}

		if (aDocument == null) {
			log("could not parse xml in log file: " + log, Project.MSG_ERR);
			return;
		}

		// Get summary of problems.
		// By API, nodeList should never be null.
		NodeList nodeList = aDocument.getElementsByTagName("problem");

		int length = nodeList.getLength();
		for (int i = 0; i < length; i++) {
			Node problemNode = nodeList.item(i);
			NamedNodeMap aNamedNodeMap = problemNode.getAttributes();
			Node severityNode = aNamedNodeMap.getNamedItem("severity");
			Node idNode = aNamedNodeMap.getNamedItem("id");
			if (severityNode != null) {
				String severityNodeValue = severityNode.getNodeValue();
				if (WARNING_SEVERITY.equals(severityNodeValue)) {
					// this is a warning
					// need to check the id
					String nodeValue = idNode.getNodeValue();
					if (ForbiddenReferenceID.equals(nodeValue)) {
						forbiddenWarningCount++;
					}
					else if (DiscouragedReferenceID.equals(nodeValue)) {
						discouragedWarningCount++;
					}
					else {
						warningCount++;
					}
				}
				else if (ERROR_SEVERITY.equals(severityNodeValue)) {
					// this is an error
					errorCount++;
				}
			}
		}

		// use wildcard in place of version number on directory names
		// System.out.println(log + "/n");
		String logName = log.substring(getCompileLogsDirectoryName().length() + 1);
		StringBuffer buffer = new StringBuffer(logName);
		buffer.replace(logName.indexOf("_") + 1, logName.indexOf(File.separator, logName.indexOf("_") + 1), "*");
		logName = new String(buffer);

		formatCompileErrorRow(log.replaceAll(".xml", ".html"), errorCount, warningCount, forbiddenWarningCount, discouragedWarningCount, stringBuffer);
	}

	private static byte[] getFileByteContent(String fileName) throws IOException {
		InputStream stream = null;
		try {
			File file = new File(fileName);
			stream = new FileInputStream(file);
			return getInputStreamAsByteArray(stream, (int) file.length());
		}
		finally {
			if (stream != null) {
				try {
					stream.close();
				}
				catch (IOException e) {
					// ignore
				}
			}
		}
	}

	/**
	 * Returns the given input stream's contents as a byte array. If a length
	 * is specified (ie. if length != -1), only length bytes are returned.
	 * Otherwise all bytes in the stream are returned. Note this doesn't close
	 * the stream.
	 * 
	 * @throws IOException
	 *             if a problem occured reading the stream.
	 */
	private static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
		byte[] contents;
		if (length == -1) {
			contents = new byte[0];
			int contentsLength = 0;
			int amountRead = -1;
			do {
				int amountRequested = Math.max(stream.available(), DEFAULT_READING_SIZE); // read
				// at
				// least
				// 8K

				// resize contents if needed
				if (contentsLength + amountRequested > contents.length) {
					System.arraycopy(contents, 0, contents = new byte[contentsLength + amountRequested], 0, contentsLength);
				}

				// read as many bytes as possible
				amountRead = stream.read(contents, contentsLength, amountRequested);

				if (amountRead > 0) {
					// remember length of contents
					contentsLength += amountRead;
				}
			}
			while (amountRead != -1);

			// resize contents if necessary
			if (contentsLength < contents.length) {
				System.arraycopy(contents, 0, contents = new byte[contentsLength], 0, contentsLength);
			}
		}
		else {
			contents = new byte[length];
			int len = 0;
			int readSize = 0;
			while ((readSize != -1) && (len != length)) {
				// See PR 1FMS89U
				// We record first the read size. In this case len is the
				// actual read size.
				len += readSize;
				readSize = stream.read(contents, len, length - len);
			}
		}

		return contents;
	}

	public String readFile(String fileName) {
		byte[] aByteArray = null;
		try {
			aByteArray = getFileByteContent(fileName);
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		if (aByteArray == null) {
			return "";
		}
		return new String(aByteArray);
	}

	private int countCompileErrors(String aString) {
		return extractNumber(aString, "error");
	}

	private int countCompileWarnings(String aString) {
		return extractNumber(aString, "warning");
	}

	private int countForbiddenWarnings(String aString) {
		return extractNumber(aString, "Access restriction:");
	}

	private int countDiscouragedWarnings(String aString) {
		return extractNumber(aString, "Discouraged access:");
	}

	private int extractNumber(String aString, String endToken) {
		int endIndex = aString.lastIndexOf(endToken);
		if (endIndex == -1) {
			return 0;
		}

		int startIndex = endIndex;
		while (startIndex >= 0 && aString.charAt(startIndex) != '(' && aString.charAt(startIndex) != ',') {
			startIndex--;
		}

		String count = aString.substring(startIndex + 1, endIndex).trim();
		try {
			return Integer.parseInt(count);
		}
		catch (NumberFormatException e) {
			return 0;
		}

	}

	public boolean includeAll;
	private int totalErrors;
	private int totalAccess;
	private int totalWarnings;
	private int rowCount;
	private int totaldiscouragedAccessWarningCount;
	private int totalforbiddenAccessWarningCount;

	private void parseUnitTestXml() throws IOException, TransformerFactoryConfigurationError, TransformerException {

		File sourceDirectory = new File(xmlDirectoryName);

		if (sourceDirectory.exists()) {

			int grandTotalErrors = 0;
			int grandTotalTests = 0;
			float grandTotalTime = 0;

			String replaceString = "";

			File[] xmlFileNames = sourceDirectory.listFiles();
			Arrays.sort(xmlFileNames);

			for (int i = 0; i < xmlFileNames.length; i++) {
				if (xmlFileNames[i].getPath().endsWith(".xml")) {
					String fullName = xmlFileNames[i].getPath();
					UnitTestResults unitTestResults = countErrors(fullName);
					int errorCount = unitTestResults.getErrors() + unitTestResults.getFailures();
					if (errorCount != 0) {
						String testName = xmlFileNames[i].getName().substring(0, xmlFileNames[i].getName().length() - 4);
						testResultsWithProblems = testResultsWithProblems.concat(EOL + testName);
					}

					String tmp = formatTestRow(xmlFileNames[i].getPath(), errorCount, unitTestResults.getTotalTests(), unitTestResults.getTime());
					replaceString = replaceString + tmp;

					if (errorCount > 0) {
						grandTotalErrors = grandTotalErrors + errorCount;
					}
					else if (errorCount < 0) {
						grandTotalErrors = grandTotalErrors + 1;
					}

					if (unitTestResults.getTotalTests() > 0) {
						grandTotalTests = grandTotalTests + unitTestResults.getTotalTests();
					}
					
					if (unitTestResults.getTime() > 0) {
						grandTotalTime = grandTotalTime + unitTestResults.getTime();
					}

				}
			}

			String tmp = formatTestRow("TOTALS", grandTotalErrors, grandTotalTests, grandTotalTime);
			replaceString = replaceString + tmp;

			testResultsTemplateString = replace(testResultsTemplateString, testResultsToken, replaceString);
			testsRan = true;

			writeUnitTestSummary(dropDirectoryName, grandTotalErrors, grandTotalTests, grandTotalTime);

		}
		else {
			testsRan = false;
			System.out.println("Test results not found in " + sourceDirectory.getAbsolutePath());
		}

	}

	/**
	 * @param grandTotalErrors
	 * @param grandTotalTests
	 * @throws IOException
	 * @throws TransformerException
	 * @throws TransformerFactoryConfigurationError
	 */
	private void writeUnitTestSummary(String filename, int grandTotalErrors, int grandTotalTests, float grandTotalTime) throws IOException, TransformerFactoryConfigurationError, TransformerException {
		String outputFileName = filename + "/unitTestsSummary" + ".xml";
		System.out.println("unitTestsSummary: " + outputFileName);
		File file = new File(outputFileName);
		file.createNewFile();
		Node rootNode = createNewDOM("unitTestsSummary");
		addSummaryNodeTo(rootNode, "grandTotalErrors", grandTotalErrors);
		addSummaryNodeTo(rootNode, "grandTotalTests", grandTotalTests);
		addSummaryNodeTo(rootNode, "grandTotalTimes", grandTotalTime);
		serialize(rootNode, file);
	}

	private String replace(String source, String original, String replacement) {

		int replaceIndex = source.indexOf(original);
		if (replaceIndex > -1) {
			String resultString = source.substring(0, replaceIndex);
			resultString = resultString + replacement;
			resultString = resultString + source.substring(replaceIndex + original.length());
			return resultString;
		}
		else {
			System.out.println("Could not find token: " + original);
			return source;
		}

	}

	private void writeTestResultsFile() {

		String outputFileName = dropDirectoryName + File.separator + testResultsHtmlFileName;
		writeFile(outputFileName, testResultsTemplateString);
	}

	private void writeFile(String outputFileName, String contents) {
		FileWriter outputWriter = null;
		try {
			outputWriter = new FileWriter(outputFileName);
			outputWriter.write(contents);
		}
		catch (FileNotFoundException e) {
			System.out.println("File not found exception writing: " + outputFileName);
		}
		catch (IOException e) {
			System.out.println("IOException writing: " + outputFileName);
		}
		finally {
			if (outputWriter != null) {
				try {
					outputWriter.close();
				}
				catch (IOException e) {
					System.out.println("IOException closing: " + outputFileName);
				}
			}
		}
	}

	public void setTestResultsHtmlFileName(String aString) {
		testResultsHtmlFileName = aString;
	}

	public String getTestResultsHtmlFileName() {
		return testResultsHtmlFileName;
	}

	public void setTestResultsTemplateFileName(String aString) {
		testResultsTemplateFileName = aString;
	}

	public String getTestResultsTemplateFileName() {
		return testResultsTemplateFileName;
	}

	public void setXmlDirectoryName(String aString) {
		xmlDirectoryName = aString;
	}

	public String getXmlDirectoryName() {
		return xmlDirectoryName;
	}

	public void setHtmlDirectoryName(String aString) {
		htmlDirectoryName = aString;
	}

	public String getHtmlDirectoryName() {
		return htmlDirectoryName;
	}

	public void setDropDirectoryName(String aString) {
		dropDirectoryName = aString;
	}

	public String getDropDirectoryName() {
		return dropDirectoryName;
	}

	private void formatCompileErrorRow(String fileName, int errorCount, int warningCount, int forbiddenAccessWarningCount, int discouragedAccessWarningCount, StringBuffer buffer) {

		int accessRuleWarningCount = forbiddenAccessWarningCount + discouragedAccessWarningCount;
		totalErrors = totalErrors + errorCount;
		totalAccess = totalAccess + accessRuleWarningCount;
		totalWarnings = totalWarnings + warningCount;
		totalforbiddenAccessWarningCount = totalforbiddenAccessWarningCount + forbiddenAccessWarningCount;
		totaldiscouragedAccessWarningCount = totaldiscouragedAccessWarningCount + discouragedAccessWarningCount;
		rowCount = rowCount + 1;

		if (!isIncludeAll()) {
			if (errorCount == 0 && warningCount == 0 && accessRuleWarningCount == 0) {
				return;
			}
		}

		int pos = fileName.indexOf(getHrefCompileLogsTargetPath());

		String shortName = fileName.substring(pos + getHrefCompileLogsTargetPath().length());
		String displayName = shortName;

		String stripString = "/plugins/";
		pos = displayName.indexOf(stripString);
		if (pos != -1) {
			displayName = displayName.substring(pos + stripString.length());
		}

		// we assume there's always a slash preceeding filename
		pos = displayName.lastIndexOf('/');
		if (pos != -1) {
			displayName = displayName.substring(0, pos);
		}

		// if there's any remaining slashes ... it is one or more
		// subdirectories of where jars are, so we need to
		// save before we strip off version numbers
		String remaining = null;
		pos = displayName.indexOf('/');
		if (pos != -1) {
			remaining = displayName.substring(pos);
			displayName = displayName.substring(0, pos);
		}
		displayName = stripOffVersionNumber(displayName);
		if (remaining != null) {
			displayName = displayName + remaining;
		}

		String rowtype = "normaltable";
		if (errorCount > 0 || forbiddenAccessWarningCount > 0) {
			rowtype = "errortable";
		}
		else if (warningCount > 0 || discouragedAccessWarningCount > 0) {
			rowtype = "warningtable";
			if (warningCount > 15 || discouragedAccessWarningCount > 0) {
				rowtype = "extraWarningTable";
			}
		}

		buffer.append("<tr CLASS=\"" + rowtype + "\">" + EOL).append("<td>" + EOL).append("<a href=\"").append(getHrefCompileLogsTargetPath()).append(shortName).append("\" type='text/plain' >").append(displayName).append("</a></td>").append(EOL)

		.append("<td CLASS=\"numeric\">").append("<a href=\"").append(getHrefCompileLogsTargetPath()).append(shortName).append("#ERRORS").append("\" type='text/plain' >").append(errorCount).append("</a></td>").append(EOL)

		.append("<td CLASS=\"numeric\">").append("<a href=\"").append(getHrefCompileLogsTargetPath()).append(shortName).append("#OTHER_WARNINGS").append("\" type='text/plain' >").append(warningCount).append("</a></td>")

		.append("<td CLASS=\"numeric\">").append("<a href=\"").append(getHrefCompileLogsTargetPath()).append(shortName).append("#ACCESSRULES_WARNINGS").append("\" type='text/plain' >").append(forbiddenAccessWarningCount).append("</a></td>").append(EOL)

		.append("<td CLASS=\"numeric\">").append("<a href=\"").append(getHrefCompileLogsTargetPath()).append(shortName).append("#ACCESSRULES_WARNINGS").append("\" type='text/plain' >").append(discouragedAccessWarningCount).append("</a></td>").append(EOL)

		.append(EOL + "</tr>" + EOL);
	}

	/**
	 * @param displayName
	 * @return
	 */
	private String stripOffVersionNumber(String displayName) {
		String result = displayName;
		nameParser.parse(result);
		result = nameParser.getProjectString();

		// debug and test
		// System.out.println("project: " + result + " version: " +
		// nameParser.getVersionString());
		return result;
	}

	private String formatTestRow(String fileName, int errorCount, int totalTests, float totalTimes) {

		// replace .xml with .html

		String aString = "";

		if (fileName.endsWith(".xml")) {

			int begin = fileName.lastIndexOf(File.separatorChar);
			int end = fileName.lastIndexOf(".xml");

			String shortName = fileName.substring(begin + 1, end);
			String displayName = shortName;

			String rowtype = "normaltable";
			if (errorCount > 0 || errorCount < 0) {
				rowtype = "errortable";
			}
			else if (totalTests < 3) {
				rowtype = "warningtable";
				if (totalTests == 0) {
					rowtype = "extraWarningTable";
				}
			}

			aString = aString + "<tr CLASS=\"" + rowtype + "\">" + EOL;

			if (errorCount < 0) {
				aString = aString + "<td>" + displayName + "</td>" + EOL;
				aString = aString + "<td CLASS=\"" + "numeric" + "\">" + "DNF" + "</td>" + EOL;
				aString = aString + "<td CLASS=\"" + "numeric" + "\">" + "0" + " </td>" + EOL;
			}
			else {
				aString = aString + "<td>" + "<a href=" + "\"" + hrefTestResultsTargetPath + "/" + shortName + ".html" + "\">" + displayName + "</a>" + "</td>" + EOL;
				aString = aString + "<td CLASS=\"" + "numeric" + "\">" + String.valueOf(errorCount) + "</td>" + EOL;
				aString = aString + "<td CLASS=\"" + "numeric" + "\">" + String.valueOf(totalTests) + "</td>" + EOL;
			}


			aString = aString + "<td CLASS=\"" + "numeric" + "\">" + String.valueOf(totalTimes) + "</td>" + EOL;

			aString = aString + "</tr>" + EOL;
		}

		else {
			// not really file name (but "TOTALS")
			String displayName = fileName;
			String rowtype = "bold";
			if (errorCount > 0) {
				rowtype = "errortable" + " " + rowtype;
			}
			aString = aString + "<tr CLASS=\"" + rowtype + "\">" + EOL;
			aString = aString + "<td>" + displayName + "</td>" + EOL;
			aString = aString + "<td CLASS=\"" + "numeric" + "\">" + String.valueOf(errorCount) + "</td>" + EOL;
			aString = aString + "<td CLASS=\"" + "numeric" + "\">" + String.valueOf(totalTests) + "</td>" + EOL;

			aString = aString + "<td CLASS=\"" + "numeric" + "\">" + String.valueOf(totalTimes) + "</td>" + EOL;

		}

		return aString;

	}

	private UnitTestResults countErrors(String fileName) {
		UnitTestResults result = new UnitTestResults();

		if (new File(fileName).length() == 0)
			return result;

		int errorCount = 0;
		int failureCount = 0;
		int totalTests = 0;
		float time = 0;
		try {
			DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
			parser = docBuilderFactory.newDocumentBuilder();

			Document document = parser.parse(fileName);
			NodeList elements = document.getElementsByTagName(TEST_SUITE_ELEMENT_NAME);

			int elementCount = elements.getLength();
			if (elementCount == 0)
				return result;
			for (int i = 0; i < elementCount; i++) {
				Element element = (Element) elements.item(i);
				NamedNodeMap attributes = element.getAttributes();
				Node aNode = attributes.getNamedItem("errors");
				errorCount = errorCount + Integer.parseInt(aNode.getNodeValue());
				aNode = attributes.getNamedItem("failures");
				errorCount = errorCount + Integer.parseInt(aNode.getNodeValue());

				aNode = attributes.getNamedItem("tests");
				totalTests = totalTests + Integer.parseInt(aNode.getNodeValue());
				
				aNode = attributes.getNamedItem("time");
				time = Float.parseFloat(aNode.getNodeValue());
			}

			result.setErrors(errorCount);
			result.setFailures(failureCount);
			result.setTotalTests(totalTests);
			result.setTime(time);
		}
		catch (IOException e) {
			System.out.println("IOException: " + fileName);
			// e.printStackTrace();
			return result;
		}
		catch (SAXException e) {
			System.out.println("SAXException: " + fileName);
			// e.printStackTrace();
			return result;
		}
		catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
		return result;
	}

	/**
	 * Gets the hrefTestResultsTargetPath.
	 * 
	 * @return Returns a String
	 */
	public String getHrefTestResultsTargetPath() {
		return hrefTestResultsTargetPath;
	}

	/**
	 * Sets the hrefTestResultsTargetPath.
	 * 
	 * @param hrefTestResultsTargetPath
	 *            The hrefTestResultsTargetPath to set
	 */
	public void setHrefTestResultsTargetPath(String htmlTargetPath) {
		this.hrefTestResultsTargetPath = htmlTargetPath;
	}

	/**
	 * Gets the compileLogsDirectoryName.
	 * 
	 * @return Returns a String
	 */
	public String getCompileLogsDirectoryName() {
		return compileLogsDirectoryName;
	}

	/**
	 * Sets the compileLogsDirectoryName.
	 * 
	 * @param compileLogsDirectoryName
	 *            The compileLogsDirectoryName to set
	 */
	public void setCompileLogsDirectoryName(String compileLogsDirectoryName) {
		this.compileLogsDirectoryName = compileLogsDirectoryName;
	}

	/**
	 * Gets the hrefCompileLogsTargetPath.
	 * 
	 * @return Returns a String
	 */
	public String getHrefCompileLogsTargetPath() {
		return hrefCompileLogsTargetPath;
	}

	/**
	 * Sets the hrefCompileLogsTargetPath.
	 * 
	 * @param hrefCompileLogsTargetPath
	 *            The hrefCompileLogsTargetPath to set
	 */
	public void setHrefCompileLogsTargetPath(String hrefCompileLogsTargetPath) {
		this.hrefCompileLogsTargetPath = hrefCompileLogsTargetPath;
	}

	/**
	 * Gets the testManifestFileName.
	 * 
	 * @return Returns a String
	 */
	public String getTestManifestFileName() {
		return testManifestFileName;
	}

	/**
	 * Sets the testManifestFileName.
	 * 
	 * @param testManifestFileName
	 *            The testManifestFileName to set
	 */
	public void setTestManifestFileName(String testManifestFileName) {
		this.testManifestFileName = testManifestFileName;
	}

	/**
	 * Gets the dropHtmlFileName.
	 * 
	 * @return Returns a String
	 */
	public String getDropHtmlFileName() {
		return dropHtmlFileName;
	}

	/**
	 * Sets the dropHtmlFileName.
	 * 
	 * @param dropHtmlFileName
	 *            The dropHtmlFileName to set
	 */
	public void setDropHtmlFileName(String dropHtmlFileName) {
		this.dropHtmlFileName = dropHtmlFileName;
	}

	private void getDropTokensFromList(String list) {
		StringTokenizer tokenizer = new StringTokenizer(list, ",");
		dropTokens = new Vector();

		while (tokenizer.hasMoreTokens()) {
			dropTokens.add(tokenizer.nextToken());
		}
	}

	public String getDropTokenList() {
		return dropTokenList;
	}

	public void setDropTokenList(String dropTokenList) {
		this.dropTokenList = dropTokenList;
	}

	public boolean isBuildTested() {
		return isBuildTested;
	}

	public void setIsBuildTested(boolean isBuildTested) {
		this.isBuildTested = isBuildTested;
	}

	/**
	 * @return
	 */
	public boolean testsRan() {
		return testsRan;
	}

	/**
	 * @param b
	 */
	public void setTestsRan(boolean b) {
		testsRan = b;
	}

	/**
	 * @return
	 */
	public Vector getDropTokens() {
		return dropTokens;
	}

	/**
	 * @param vector
	 */
	public void setDropTokens(Vector vector) {
		dropTokens = vector;
	}

	/**
	 * @return
	 */
	public String getTestResultsWithProblems() {
		return testResultsWithProblems;
	}

	/**
	 * @param string
	 */
	public void setTestResultsWithProblems(String string) {
		testResultsWithProblems = string;
	}

	public String getBuildType() {
		return buildType;
	}

	public void setBuildType(String buildType) {
		this.buildType = buildType;
	}

	public void setPlatformIdentifierToken(String platformIdentifierToken) {
		this.platformIdentifierToken = platformIdentifierToken;
	}

	public String getPlatformIdentifierToken() {
		return platformIdentifierToken;
	}

	public boolean isIncludeAll() {
		return includeAll;
	}

	public void setIncludeAll(boolean includeAll) {
		this.includeAll = includeAll;
	}

}
