package org.eclipse.jst.jsf.common.runtime.internal.util.jem;

import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

/**
 * Convenience methods for using bean proxies
 * @author cbateman
 *
 */
public final class BeanProxyUtil 
{
    
    public static class BeanProxyWrapper
    {
        IBeanTypeProxy      _typeProxy;
        IBeanProxy      _instance;

        public BeanProxyWrapper(IBeanTypeProxy typeProxy) {
            super();
            _typeProxy = typeProxy;
        }
        
        public void init() throws ThrowableProxy
        {
            if (_instance == null)
            {
                _instance = _typeProxy.newInstance();
            }
        }
        
        public void reinit() throws ThrowableProxy
        {
            _instance = null;
            init();
        }
        
        public IBeanProxy call(final String methodName)
        {
            IMethodProxy  method = _instance.getTypeProxy().getMethodProxy(methodName);
            if (method != null)
            {
                try
                {
                    return method.invoke(_instance);
                }
                catch (ThrowableProxy  tp)
                {
                    // do nothing, fallthrough
                    tp.printProxyStackTrace();
                }
            }
            
            return null;
        }
        
        public String callStringMethod(final String methodName)
        {
            IBeanProxy result = call(methodName);
            
            if  (result instanceof IStringBeanProxy)
            {
                return ((IStringBeanProxy)result).stringValue();
            }
            
            return null;
        }
    }
}
