package org.eclipse.wst.common.tests.performance.internal;

import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;

public class CleanBuildTestCase extends PerformanceTestCase
{
  public void testCleanBuild()
  {
    tagAsSummary("Large workspace clean build test", new Dimension[] {Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
    startMeasuring();
    try
    {
      ResourcesPlugin.getWorkspace().build(IncrementalProjectBuilder.CLEAN_BUILD, new NullProgressMonitor());
      boolean interrupted = true;
      while (interrupted)
      {
        try
        {
          Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, new NullProgressMonitor());
          interrupted = false;
        }
        catch (InterruptedException e)
        {
        }
      }
    }
    catch (CoreException ce)
    {
      fail(ce.getMessage());
    }
    stopMeasuring();
    commitMeasurements();
    assertPerformance();
  }
}