/**********************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved.  This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
*
 **********************************************************************/

package org.eclipse.wst.common.tests.performance.internal;

import junit.framework.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class PerformanceUITestApplication implements IPlatformRunnable, ITestHarness
{
  private String WORKBENCH_ID = "org.eclipse.ui.ide.workbench";
  private TestableObject testableObject;

  public Object run(final Object args) throws Exception
  {
    IExtension extension = Platform.getExtensionRegistry().getExtension(Platform.PI_RUNTIME, Platform.PT_APPLICATIONS, WORKBENCH_ID);
    Assert.assertNotNull(extension);
    IPlatformRunnable application = null;
    IConfigurationElement[] elements = extension.getConfigurationElements();
    if (elements.length > 0)
    {
      IConfigurationElement[] runs = elements[0].getChildren("run"); //$NON-NLS-1$
      if (runs.length > 0)
      {
        Object runnable = runs[0].createExecutableExtension("class"); //$NON-NLS-1$
        if (runnable instanceof IPlatformRunnable)
          application = (IPlatformRunnable)runnable;
      }
    }
    Assert.assertNotNull(application);
    testableObject = PlatformUI.getTestableObject();
    testableObject.setTestHarness(this);
	return application.run(args);
  }

  public void runTests()
  {
    testableObject.testingStarting();
    testableObject.runTest(new Runnable()
    {
      public void run()
      {
        try
        {
          EclipseTestRunner.run(Platform.getCommandLineArgs());
        }
        catch (Exception t)
        {
          t.printStackTrace();
        }
      }
    });
    testableObject.testingFinished();
  }
}