package org.eclipse.wst.common.tests.performance.internal.scalability;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;

public abstract class OpenEditorTestCase extends ScalabilityTestCase
{
  protected abstract String getEditorId();
  protected abstract String getBundleId();
  protected abstract String getFilePath();

  protected IFile file;

  protected void setUp() throws Exception
  {
    super.setUp();
    IProject project = createProject("sp");
    String bundleId = getBundleId();
    file = copyFile(bundleId, getFilePath(), project);
    joinBackgroundJobs(3000);
  }

  public void execute() throws Exception
  {
    tagAsSummary(getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
    startMeasuring();
    openEditor(getEditorId(), file);
    stopMeasuring();
    commitMeasurements();
    assertPerformance();
  }

  protected void openEditor(String editorId, IFile file) throws PartInitException
  {
    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    IEditorPart editor = workbenchWindow.getActivePage().openEditor(new FileEditorInput(file), editorId, true);
    EditorTestHelper.runEventQueue(editor);
    workbenchWindow.getActivePage().closeEditor(editor, false);
    try
    {
      EditorTestHelper.joinBackgroundActivities();
    }
    catch (CoreException e)
    {
      fail(e.getMessage());
    }
  }
}