package org.eclipse.wst.common.tests.performance.internal.scalability;

import org.eclipse.test.performance.Dimension;


public abstract class RepeatRunValidatorTestCase extends RunValidatorTestCase
{
  protected abstract int getRepeatCount();

  public void execute() throws Exception
  {
    tagAsSummary(getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
    startMeasuring();
    int count = getRepeatCount();
    for (int i = 0; i < count; i++)
      runValidator(file);
    stopMeasuring();
    commitMeasurements();
    assertPerformance();
  }
}