package org.eclipse.wst.common.tests.performance.internal.scalability;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;

public abstract class ScalabilityTestCase extends PerformanceTestCase
{
  protected IProject createProject(String name) throws CoreException
  {
    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    if (!project.exists())
    {
      project.create(null);
      project.open(null);
    }
    return project;
  }

  protected IFile copyFile(String bundleId, String path, IContainer dest) throws IOException, CoreException
  {
    return copyFile(bundleId, path, dest, null);
  }

  protected IFile copyFile(String bundleId, String path, IContainer dest, String suffix) throws IOException, CoreException
  {
    URL url = Platform.getBundle(bundleId).getEntry(path);
    String fileName = url.getFile();
    if (suffix != null && suffix.length() > 0)
    {
      int i = fileName.lastIndexOf('.');
      if (i != -1)
      {
        StringBuffer sb = new StringBuffer();
        sb.append(fileName.substring(0, i));
        sb.append(suffix);
        sb.append(fileName.substring(i));
        fileName = sb.toString();
      }
      else
        fileName = fileName + suffix;
    }
    IFile file = dest.getFile(new Path(fileName));
    if (!file.exists())
    {
      createFolders(file.getParent());
      file.create(url.openStream(), true, null);
    }
    return file;
  }

  protected void createFolders(IContainer container) throws CoreException
  {
    if (!container.exists() && container instanceof IFolder)
    {
      createFolders(container.getParent());
      ((IFolder)container).create(true, true, null);
    }
  }

  protected void joinBackgroundJobs(final int wait)
  {
    Display.getDefault().syncExec(new Runnable()
    {
      public void run()
      {
        try
        {
          Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException e)
        {
        }
        long start = System.currentTimeMillis();
        Display display = Display.getDefault();
        while (System.currentTimeMillis() - start < wait)
        {
          if (!display.readAndDispatch())
          {
            display.sleep();
          }
        }
      }
    });
    EditorTestHelper.runEventQueue();
  }

  protected String getClassName()
  {
    String name = getClass().getName();
    int i = name.lastIndexOf('.');
    if (i != -1)
      name = name.substring(i+1);
    return name;
  }
  
  protected void deleteProject(String projectName)
  {
    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    try
    {
      project.delete(true, new NullProgressMonitor());
    }
    catch (CoreException e)
    {
      e.printStackTrace();
    }
  }
}