/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

public class EnumSelectionTest extends AbstractSelectionTest {
public EnumSelectionTest(String testName) {
	super(testName);
}
// https://bugs.eclipse.org/bugs/show_bug.cgi?id=85379
public void test0001() {

	String str =
		"public class X {		\n" + 
		"  void foo() {								\n" +
		"    switch(e) {  							\n" +
		"      case A:								\n" +
		"        break;								\n" +
		"    }        								\n" +
		"  }        								\n" +
		"}											\n"; 

	String selectionStartBehind = "case ";
	String selectionEndBehind = "A";
	
	String expectedCompletionNodeToString = "<SelectOnName:A>";
	String completionIdentifier = "A";
	String expectedUnitDisplayString =
		"public class X {\n" + 
		"  public X() {\n" + 
		"  }\n" + 
		"  void foo() {\n" + 
		"    {\n" + 
		"      switch (e) {\n" + 
		"      case <SelectOnName:A> : ;\n" + 
		"      }\n" + 
		"    }\n" + 
		"  }\n" + 
		"}\n";
	String expectedReplacedSource = "A";
	String testName = "<select test>";

	int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
	int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
		
	this.checkMethodParse(
		str.toCharArray(), 
		selectionStart,
		selectionEnd,
		expectedCompletionNodeToString,
		expectedUnitDisplayString,
		completionIdentifier,
		expectedReplacedSource,
		testName);
}
}
