/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.  This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *    IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.wst.xsd.tests.performance;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class XSDPerformancePlugin extends Plugin
{
  // The shared instance.
  private static XSDPerformancePlugin plugin;

  // TODO: This constant should really be pulled from the plugin which declares it.
  // This will avoid "magic string" dependencies which can be easily broken.
  public static final String XSD_VALIDATOR_ID = "org.eclipse.wst.xsd.core.xsd"; //$NON-NLS-1$

  public static final String BUNDLE_ID = "org.eclipse.wst.xsd.tests.performance"; //$NON-NLS-1$

  /**
   * The constructor.
   */
  public XSDPerformancePlugin()
  {
    super();
    plugin = this;
  }

  /**
   * This method is called upon plug-in activation
   */
  public void start(BundleContext context) throws Exception
  {
    super.start(context);
  }

  /**
   * This method is called when the plug-in is stopped
   */
  public void stop(BundleContext context) throws Exception
  {
    super.stop(context);
    plugin = null;
  }

  /**
   * Returns the shared instance.
   */
  public static XSDPerformancePlugin getDefault()
  {
    return plugin;
  }
}
