/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wtp.releng.tools.component.adopters;

/**
 * This encapsulates a field reference sub type of NamedRef.
 */
public class FieldRef extends NamedRef {
  
  /**
   * Override the toString method to return information specific to field references
   */
  public String toString() {
    StringBuffer sb = new StringBuffer();
    sb.append("<field name=\""); //$NON-NLS-1$
    sb.append(getName());
    sb.append("\" desc=\""); //$NON-NLS-1$
    sb.append(getDescriptor());
    sb.append("\" ref=\""); //$NON-NLS-1$
    sb.append(getRefCount());
    sb.append("\"/>"); //$NON-NLS-1$
    return sb.toString();
  }
}