/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wtp.releng.tools.component.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Message
{
  private static ResourceBundle bundle;

  public static String getMessage(String key)
  {
    if (bundle == null)
    {
      try
      {
        bundle = ResourceBundle.getBundle("org.eclipse.wtp.releng.tools.component.ui.component");
      }
      catch (MissingResourceException e)
      {
        return key;
      }
    }
    return bundle.getString(key);
  }

  public static String getMessage(String key, String[] subsitutes)
  {
    return MessageFormat.format(getMessage(key), subsitutes);
  }
}