package org.eclipse.jst.jsf.common.runtime.internal.model.component;

public class ComponentFactory 
{
    
    public static ComponentInfo createComponentInfo(final String id, final String parentId, final String componentFamily, final String renderFamily, final String componentType, final String componentClass)
    {
        final ComponentTypeInfo typeInfo = new ComponentTypeInfo(componentType, componentClass, componentFamily, renderFamily);
        return new ComponentInfo(id, parentId, typeInfo);
    }
    
    public static FacetInfo createFacetInfo(final String id, final String parentId, final String componentFamily, final String renderFamily, final String componentType, final String componentClass)
    {
        final ComponentTypeInfo typeInfo =
            new ComponentTypeInfo(componentType, componentClass, componentFamily, renderFamily);
        return new FacetInfo(id, parentId, typeInfo);
    }
    
    public static UIInputInfo createUIInputInfo(final String id, final String parentId, final String componentFamily, final String renderFamily,  String isValid, String isImmediate, String isRequired, String isRendered, final String componentType, final String componentClass)
    {
        final ComponentTypeInfo typeInfo = new ComponentTypeInfo(componentType, componentClass, componentFamily, renderFamily);
        return new UIInputInfo(id, parentId, typeInfo, isValid, isImmediate, isRequired, isRendered);
    }
    
    public static UIOutputInfo createUIOutputInfo(final String id, final String parentId, final String componentFamily, final String renderFamily,  String isRendered, final String componentType, final String componentClass)
    {
        final ComponentTypeInfo typeInfo = new ComponentTypeInfo(componentType, componentClass, componentFamily, renderFamily);
        return new UIOutputInfo(id, parentId, typeInfo, isRendered);
    }
}
