package org.eclipse.jst.jsf.common.runtime.internal.model.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jst.jsf.common.runtime.internal.debug.RenderNode;


/**
 * Models a basic UI component instance
 * TODO: should implement a visitor pattern to traverse component trees
 * @author cbateman
 *
 */
public class ComponentInfo implements Serializable
{
    /**
     * serializable id
     */
    private static final long serialVersionUID = 2517204356825585699L;
    
    protected final String              _id;
    protected final String              _parentId;
    protected final ComponentTypeInfo   _componentTypeInfo;
    protected RenderNode                _rootRenderedNode; // may be null if we don't have it

    ComponentInfo(final String id, final String parentId, final ComponentTypeInfo componentTypeInfo)
    {
        _id = translateForNull(id);
        _parentId = parentId;
        _componentTypeInfo = componentTypeInfo;
    }
    
    private String translateForNull(final String arg)
    {
        
        if (arg == null || "!".equals(arg.trim()))
        {
            return null;
        }
        return arg.trim();
    }
    
    private List/*<ComponentInfo>*/    _children = new ArrayList/*<ComponentInfo>*/();

    public final String getId() {
        return _id;
    }

    public final ComponentTypeInfo getComponentTypeInfo() {
        return _componentTypeInfo;
    }

    public final List/*<ComponentInfo>*/ getChildren() {
        return _children;
    }
    
    public String toString()
    {
        return getMostSpecificComponentName()+": id="+_id+", family="+_componentTypeInfo.getComponentFamily()+", render="+_componentTypeInfo.getRenderFamily();
    }
    
    public String getMostSpecificComponentName()
    {
        return "Component";
    }

    public final void setRenderNode(RenderNode rootNode)
    {
        _rootRenderedNode = rootNode;
    }
    
    public final RenderNode getRenderNode()
    {
        return _rootRenderedNode;
    }
}
