package org.eclipse.jst.jsf.common.runtime.internal.model.component;

public class UIInputInfo extends UIOutputInfo 
{
    /**
     * serializable uid
     */
    private static final long serialVersionUID = -6055473902554910848L;
    private final boolean _isValid;
    private final boolean _isImmediate;
    private final boolean _isRequired;
    
    UIInputInfo(String id, String parentId, ComponentTypeInfo typeInfo, String isValid, String isImmediate, String isRequired, String isRendered) {
        super(id, parentId, typeInfo, isRendered);
        _isValid = Boolean.valueOf(isValid).booleanValue();
        _isImmediate = Boolean.valueOf(isImmediate).booleanValue();
        _isRequired = Boolean.valueOf(isRequired).booleanValue();
    }
    
    public String toString()
    {
        String toString = super.toString();
        return toString + ", isValid="+_isValid+", isImmediate="+_isImmediate+", isRequired="+_isRequired;
    }

    //@Override
    public String getMostSpecificComponentName() 
    {
        return "UIInput";
    }
}
