/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Fabrizio Giustina - Initial API and implementation
 **********************************************************************/
package org.eclipse.jst.server.tomcat.loader;

import java.io.File;
import java.util.StringTokenizer;

import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappLoader;

public class WtpWebappLoader extends WebappLoader {

    private String virtualClasspath;

    public WtpWebappLoader() {
        super();
    }

    public WtpWebappLoader(ClassLoader parent) {

        // patch for tomcat versions affected by
        // http://issues.apache.org/bugzilla/show_bug.cgi?id=36852
        // super(Thread.currentThread().getContextClassLoader());
        // this is not needed if the useSystemClassLoaderAsParent in context.xml
        // is set to false

        super(parent);
    }

    /**
     * Tomcat digester will automatically set this property to the value of the
     * "virtualClasspath" xml attribute.
     * @param path ; separated list of path elements.
     */
    public void setVirtualClasspath(String path) {
        virtualClasspath = path;
    }

    public void start() throws LifecycleException {
        StringTokenizer tkn = new StringTokenizer(virtualClasspath, ";");
        while (tkn.hasMoreTokens()) {
            File file = new File(tkn.nextToken());
            if (!file.exists()) {
                continue;
            }
            String path = file.getAbsolutePath();
            if (path.startsWith("/")) {
            	path = "file:" + path;
            } else {
            	path = "file:/" + path;
            }
            if (file.isDirectory()) {
                addRepository(path + "/");
            } else {
                addRepository(path);
            }
        }

        super.start();
    }

}
