package oracle.adfdemo.view.faces.dialog;

import java.util.Iterator;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import oracle.adf.view.faces.component.UIXTable;
import oracle.adf.view.faces.context.AdfFacesContext;

public class PeriodicDialogBean
{
  public UIXTable getTable()
  {
    return _table;
  }

  public void setTable(UIXTable table)
  {
    _table = table;
  }

  public String cancel()
  {
    AdfFacesContext.getCurrentInstance().returnFromDialog(null, null);
    return null;
  }

  public String select()
  {
    FacesContext context = FacesContext.getCurrentInstance();
    // The tableSelectOne is marked as required; so there'd better
    // be a selected row - an exception will result here if there
    // isn't.  Is there some better code?
    Iterator iterator = _table.getSelectionState().getKeySet().iterator();
    String rowKey = (String) iterator.next();
    Object oldRowKey = _table.getRowKey();
    _table.setRowKey(rowKey);
    ValueBinding binding = context.getApplication().
      createValueBinding("#{row.symbol}");
    Object value = binding.getValue(context);
    AdfFacesContext.getCurrentInstance().returnFromDialog(value, null);
    _table.setRowKey(oldRowKey);

    return null;
  }

  private UIXTable _table;
}
