/******************************************************************************
 * Copyright (c) 2006 BEA Systems, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 ******************************************************************************/

package org.eclipse.wst.project.facet.examples.enablement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/** 
 * @author <a href="mailto:kosta@bea.com">Konstantin Komissarchik</a>
 */

public final class ExampleFacetPopupAction 

	implements IObjectActionDelegate
	
{
	private Shell shell = null;
	private final List<IProject> selection = new ArrayList<IProject>();
	
	public void setActivePart( final IAction action, 
			                   final IWorkbenchPart targetPart ) 
	{
		this.shell = targetPart.getSite().getShell();
	}

	public void selectionChanged( final IAction action, 
			                      final ISelection selection ) 
	{
		this.selection.clear();
		
		if( selection instanceof IStructuredSelection )
		{
			final IStructuredSelection ssel = (IStructuredSelection) selection;
			
			for( Iterator itr = ssel.iterator(); itr.hasNext(); )
			{
				final Object obj = itr.next();
				
				if( obj instanceof IProject )
				{
					this.selection.add( (IProject) obj );
				}
			}
		}
	}
	
	public void run( final IAction action ) 
	{
		// do something.
	}

}
